# TudoAqui Super App - Arquitetura 2026

## 🏗️ Diagrama de Arquitetura

```
┌─────────────────────────────────────────────────────────────────┐
│                    FLUTTER APP (Frontend)                        │
│  ┌──────────┐  ┌──────────┐  ┌──────────┐  ┌──────────┐       │
│  │   Home   │  │ Restaur. │  │  Imóveis │  │    KYC   │       │
│  │Marketplace│  │  Tupuca  │  │  Carros  │  │ Verificação│    │
│  └──────────┘  └──────────┘  └──────────┘  └──────────┘       │
└────────────────────┬────────────────────────────────────────────┘
                     │ HTTP/WebSocket
                     ▼
┌─────────────────────────────────────────────────────────────────┐
│              API GATEWAY (NestJS - Port 3000)                    │
│                  /api/v1/* endpoints                             │
└───────┬──────────────┬──────────────┬──────────────┬───────────┘
        │              │              │              │
        ▼              ▼              ▼              ▼
┌──────────────┐ ┌──────────────┐ ┌──────────────┐ ┌──────────────┐
│   Auth       │ │     KYC      │ │ Marketplace  │ │  Logística   │
│  Module      │ │   Module     │ │   Module     │ │   Module     │
│              │ │              │ │              │ │              │
│ - Google ID  │ │ - Rekognition│ │ - Imóveis   │ │ - Tupuca API │
│ - Auth0      │ │ - Vision AI  │ │ - Automóveis│ │ - Heetch/Yango│
│ - JWT        │ │ - Liveness   │ │ - Turismo   │ │              │
│ - 2FA        │ │ - OCR BI     │ │ - Seguros   │ │              │
└──────┬───────┘ └──────┬───────┘ └──────┬───────┘ └──────┬───────┘
       │                │                │                │
       └────────────────┴────────────────┴────────────────┘
                             │
                             ▼
┌─────────────────────────────────────────────────────────────────┐
│                      DATABASES LAYER                             │
│  ┌────────────────┐  ┌────────────────┐  ┌────────────────┐    │
│  │   PostgreSQL   │  │     Redis      │  │    Firebase    │    │
│  │                │  │                │  │                │    │
│  │ - Users        │  │ - GPS Cache    │  │ - Push Notif.  │    │
│  │ - Anúncios     │  │ - Sessions     │  │ - Chat Real-time│   │
│  │ - Transações   │  │ - Rate Limit   │  │ - Storage      │    │
│  └────────────────┘  └────────────────┘  └────────────────┘    │
└─────────────────────────────────────────────────────────────────┘
                             │
                             ▼
┌─────────────────────────────────────────────────────────────────┐
│                    EXTERNAL INTEGRATIONS                         │
│  ┌───────────┐ ┌───────────┐ ┌───────────┐ ┌───────────┐      │
│  │  Amazon   │ │  Google   │ │  Multicaixa│ │   Google  │      │
│  │Rekognition│ │ Vision AI │ │  Express   │ │   Maps    │      │
│  │  (KYC)    │ │  (OCR)    │ │   (Pag.)   │ │  (Geo)    │      │
│  └───────────┘ └───────────┘ └───────────┘ └───────────┘      │
│  ┌───────────┐ ┌───────────┐ ┌───────────┐                    │
│  │  Tupuca   │ │  Heetch   │ │    GPO    │                    │
│  │(Logística)│ │  (Táxi)   │ │  (Pag.)   │                    │
│  └───────────┘ └───────────┘ └───────────┘                    │
└─────────────────────────────────────────────────────────────────┘
```

## 🔄 Fluxo de Dados - Exemplo: Verificação KYC

```
1. [Flutter App] Utilizador tira foto do BI
   └─> Compressão local (reduzir tamanho)
   └─> POST /api/v1/kyc/upload-bi (multipart/form-data)

2. [NestJS Backend] Recebe upload
   └─> Adiciona marca d'água "TudoAqui"
   └─> Upload para S3 ou storage local
   └─> Chama Amazon Rekognition DetectText
   └─> Extrai número do BI: "123456789LA043"

3. [PostgreSQL] Atualiza registo do utilizador
   └─> SET fotoBI = 's3://bucket/user123_bi.jpg'
   └─> SET biNumero = '123456789LA043'

4. [Flutter App] Utilizador tira selfie
   └─> POST /api/v1/kyc/upload-selfie

5. [NestJS Backend] Liveness Detection
   └─> Amazon Rekognition CompareFaces
   └─> Compara selfie com foto do BI
   └─> Score: 98% match

6. [PostgreSQL] Se aprovado (>95%)
   └─> SET kycStatus = 'aprovado'
   └─> SET seloVerificado = TRUE

7. [Firebase] Envia notificação push
   └─> "Parabéns! A sua conta foi verificada ✓"

8. [Flutter App] Exibe selo verde no perfil
```

## 🚀 Vantagens da Arquitetura Microserviços

### Independência
- Módulo de **Restaurantes** pode falhar sem afetar **Automóveis**
- Cada microserviço tem seu próprio ciclo de deploy

### Escalabilidade
- **Logística** pode ter 10 réplicas (alta demanda)
- **KYC** pode ter 2 réplicas (menos frequente)

### Manutenção
- Equipa A trabalha em **Marketplace**
- Equipa B trabalha em **Integrações**
- Zero conflitos no código

## 🔐 Camadas de Segurança

```
Layer 1: HTTPS + Certificate Pinning
Layer 2: JWT Token (7 dias de expiração)
Layer 3: Rate Limiting (100 requests/min)
Layer 4: CORS (apenas domínios autorizados)
Layer 5: Input Validation (class-validator)
Layer 6: Database Encryption (PostgreSQL TDE)
Layer 7: Secrets Management (AWS Secrets Manager)
```

## 📊 Performance Esperada (2026)

| Métrica                | Valor          |
|------------------------|----------------|
| Latência API           | < 100ms        |
| Throughput             | 10,000 req/s   |
| Uptime                 | 99.9%          |
| Flutter FPS            | 120 (Impeller) |
| Reconhecimento Facial  | < 2s           |
| Chat Latência          | < 50ms         |

## 🛠️ Stack Tecnológica Completa

### Frontend (Flutter)
- **Motor Gráfico:** Impeller (120 FPS)
- **Compilação:** AOT (Ahead-of-Time) para código nativo
- **Segurança:** Obfuscação + Certificate Pinning

### Backend (NestJS)
- **Runtime:** Node.js 20 LTS
- **Linguagem:** TypeScript 5.3+ (strict mode)
- **Framework:** NestJS 10.3+ (organização enterprise)

### Databases
- **PostgreSQL 16:** ACID transactions, PostGIS (geolocalização)
- **Redis 7:** Cache, GPS em tempo real, rate limiting
- **Firebase:** Realtime Database (chat), Cloud Messaging (push)

### Segurança
- **Auth:** Google Identity / Auth0 (OAuth2 + OIDC)
- **KYC:** Amazon Rekognition / Google Vision AI
- **2FA:** SMS via operadoras angolanas

### Integrações
- **Logística:** Tupuca API
- **Mobilidade:** Heetch/Yango SDK
- **Pagamentos:** Multicaixa Express + GPO
- **Maps:** Google Maps SDK

---

**Nota:** Esta arquitetura suporta até **1 milhão de utilizadores activos** com escalabilidade horizontal (adicionar mais servidores conforme necessário).
