# ⚡ EXECUTE AGORA - Comandos Prontos para Copiar & Colar

**Status**: 🟢 Tudo pronto!  
**Tempo necessário**: 15 minutos  
**Resultado**: Backend LIVE em AWS  

---

## 🟢 OPÇÃO 1: WINDOWS (PowerShell)

### Passo 1: Abrir PowerShell como Administrador
```powershell
# Clique em Windows + X → Windows PowerShell (Admin)
```

### Passo 2: Navegar para TudoAqui
```powershell
cd C:\xampp\htdocs\TudoAqui
```

### Passo 3: Permitir execução de scripts
```powershell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser -Force
```

### Passo 4: Executar setup automático (⭐ MAIS FÁCIL)
```powershell
.\SETUP_PROD.ps1
# Escolher opção "5" quando pergunta
```

**OU** execute comandos individuais:

```powershell
# 1. Gerar certificados
.\scripts\certificates.ps1

# 2. Inicializar Terraform
cd infrastructure
terraform init
terraform plan -out=tfplan
cd ..

# 3. Criar .env
if (Test-Path "backend\.env.example") {
    Copy-Item "backend\.env.example" ".env"
}

# 4. Instalar dependências
cd backend
npm install
npm test
npm run build
cd ..
```

---

## 🟢 OPÇÃO 2: macOS/Linux (Bash)

### Passo 1: Abrir Terminal

### Passo 2: Navegar para TudoAqui
```bash
cd /path/to/TudoAqui
# Exemplo: cd ~/projects/TudoAqui
```

### Passo 3: Executar setup automático (⭐ MAIS FÁCIL)
```bash
chmod +x auto-start.sh
./auto-start.sh
# Escolher opção "10" quando pergunta
```

**OU** execute comandos individuais:

```bash
# 1. Gerar certificados
mkdir -p certificates ~/.ssh
openssl rand -hex 32 > certificates/jwt_secret.txt

# 2. Inicializar Terraform
cd infrastructure
terraform init
terraform plan -out=tfplan
cd ..

# 3. Criar .env
if [ -f "backend/.env.example" ]; then
    cp backend/.env.example .env
fi

# 4. Instalar dependências
cd backend
npm install
npm test
npm run build
cd ..
```

---

## 🔑 PASSO CRITICO: PREENCHER AWS CREDENTIALS

### Abrir arquivo
```powershell
# Windows
notepad infrastructure/terraform.tfvars

# macOS/Linux
nano infrastructure/terraform.tfvars
```

### Exemplo de preenchimento
```hcl
aws_region = "us-east-1"
environment = "prod"
app_name = "tudoaqui"
instance_type = "t3.medium"
db_allocated_storage = 100
db_engine_version = "15.3"

# PREENCHER COM SEUS VALORES:
db_password = "SEU_DB_PASSWORD_SUPER_SEGURO_AQUI"

tags = {
  Environment = "production"
  Project = "TudoAqui"
  ManagedBy = "Terraform"
  Owner = "SEU_NOME_AQUI"
}
```

### Onde obter AWS credentials?
1. Ir para: https://console.aws.amazon.com/iam/
2. Clique em "Users" → "Add User"
3. Nome: `tudoaqui-terraform-deploy`
4. Permissões: "AdministratorAccess"
5. Ir para "Security credentials" → "Create access key"
6. Copiar `Access Key ID` e `Secret Access Key`
7. Colar em `terraform.tfvars`

---

## 🚀 PASSO FINAL: DEPLOY INFRASTRUCTURE

### Windows (PowerShell)
```powershell
cd infrastructure
terraform plan -out=tfplan       # Visualizar mudanças
terraform apply tfplan          # Aplicar (criar recursos AWS)
```

### macOS/Linux (Bash)
```bash
cd infrastructure
terraform plan -out=tfplan       # Visualizar mudanças
terraform apply tfplan          # Aplicar (criar recursos AWS)
```

### Esperado (~10-15 min)
```
✅ Creating VPC...
✅ Creating EC2 instance...
✅ Creating RDS PostgreSQL...
✅ Creating ElastiCache Redis...
✅ Creating S3 bucket...
✅ Creating CloudFront distribution...

Apply complete!

Outputs:
- instance_public_ip: 54.123.45.67
- rds_endpoint: tudoaqui.xxxxx.rds.amazonaws.com
- redis_endpoint: tudoaqui.xxxxx.cache.amazonaws.com
- s3_bucket: tudoaqui-media-prod
- cloudfront_domain: d123456789.cloudfront.net
```

---

## 📋 CHECKLIST PASSO-A-PASSO

```
☐ Passo 1: Abrir PowerShell/Terminal como admin
☐ Passo 2: cd para TudoAqui
☐ Passo 3: Executar .\SETUP_PROD.ps1 ou ./auto-start.sh
☐ Passo 4: Escolher opção "5" ou "10"
☐ Passo 5: Criar conta AWS (free tier)
☐ Passo 6: Gerar credenciais IAM
☐ Passo 7: Editar infrastructure/terraform.tfvars
☐ Passo 8: Executar terraform apply
☐ Passo 9: Anotar outputs (IPs, endpoints)
☐ Passo 10: Configurar DNS (tudoaqui.ao)

Status: ✅ TUDO PRONTO!
```

---

## 🔍 VERIFICAÇÃO PÓS-DEPLOY

### Testar Backend
```bash
# Substituir [EC2-PUBLIC-IP] com IP real do terraform output
curl http://[EC2-PUBLIC-IP]:3000/health

# Esperado:
# {"status":"ok","uptime":120}
```

### Testar Database
```bash
# Substituir [RDS-ENDPOINT] com endpoint do terraform output
psql -h [RDS-ENDPOINT] -U tudoaqui_admin -d tudoaqui_prod

# Depois fazer SELECT version(); para testar
```

### Testar Redis
```bash
# Usar redis-cli se instalado
redis-cli -h [REDIS-ENDPOINT] -p 6379 ping

# Esperado: PONG
```

---

## 🆘 TROUBLESHOOTING RÁPIDO

### Erro: "Terraform not found"
```powershell
# Instalar Terraform
choco install terraform -y
# Ou: scoop install terraform
```

### Erro: "AWS credentials not valid"
```powershell
# Verificar credenciais
aws configure
# Ou editar: C:\Users\YourUser\.aws\credentials
```

### Erro: "Access Denied to S3"
```
Solução: Verificar IAM policy (AdministratorAccess selecionado?)
Verificar: https://console.aws.amazon.com/iam/ → Users → tudoaqui-terraform-deploy
```

### Erro: "VPC CIDR already exists"
```powershell
# Verificar se está replicando
terraform destroy  # Limpar recursos antigos
# Depois terraform apply novamente
```

---

## 📞 FICHEIROS IMPORTANTES

| Ficheiro | Função |
|----------|--------|
| READY_FOR_PRODUCTION.md | Leia isto primeiro |
| SETUP_PROD.ps1 | Execute isto (Windows) |
| auto-start.sh | Execute isto (Mac/Linux) |
| infrastructure/terraform.tfvars | Edite com suas credenciais |
| certificates/secrets.txt | Gerado automaticamente |

---

## ⏱️ LINHA DO TEMPO ESPERADA

```
T+0 min    : Inicio (você aqui agora)
T+1 min    : SETUP_PROD.ps1 começado
T+3 min    : Terraform inicializado
T+5 min    : npm install + build completo
T+7 min    : AWS credentials preenchidas
T+8 min    : terraform apply iniciado

T+15-20 min: ✅ BACKEND LIVE!

Outputs:
- EC2 Public IP: 54.xxx.xxx.xxx
- RDS Endpoint: tudoaqui.xxx.rds.amazonaws.com
- Redis: tudoaqui.xxx.cache.amazonaws.com
- S3 Bucket: tudoaqui-media-prod
- CloudFront: dxxxxxxxxxxxxx.cloudfront.net
```

---

## 🎯 RESUMO DOS COMANDOS

### 3 COMANDOS PARA COMEÇAR (Windows)
```powershell
cd C:\xampp\htdocs\TudoAqui
Set-ExecutionPolicy RemoteSigned -Scope CurrentUser -Force
.\SETUP_PROD.ps1
# Escolher opção 5
```

### 3 COMANDOS PARA COMEÇAR (macOS/Linux)
```bash
cd /path/to/TudoAqui
chmod +x auto-start.sh
./auto-start.sh
# Escolher opção 10
```

### 2 COMANDOS PARA DEPLOY
```powershell
# Editar credentials (passo manual)
notepad infrastructure/terraform.tfvars

# Fazer deploy
cd infrastructure; terraform apply tfplan
```

---

## ✅ CONFIRMAÇÃO FINAL

Tem tudo necessário:
- ✅ Ficheiros Terraform (5)
- ✅ CI/CD pipelines (2)
- ✅ Scripts automação (5+)
- ✅ Documentação (6+)
- ✅ Secrets gerados
- ✅ Docker config
- ✅ Security setup

**Próximo passo**: Executar `SETUP_PROD.ps1` OU `auto-start.sh`

---

## 🎉 VÁ!

```
Copie e cole isto agora mesmo:

=== WINDOWS ===
cd C:\xampp\htdocs\TudoAqui
Set-ExecutionPolicy RemoteSigned -Scope CurrentUser -Force
.\SETUP_PROD.ps1

=== macOS/Linux ===
cd ~/projects/TudoAqui
chmod +x auto-start.sh
./auto-start.sh
```

**Tempo**: 15 minutos  
**Resultado**: Backend LIVE em AWS  
**Status**: 🟢 PRONTO!

---

*Última atualização: Janeiro 2026*  
*TudoAqui - Production Ready*
