# GitHub Setup Script para TudoAqui

## Instruções de Setup

### 1. Criar repositório GitHub

```bash
# Login GitHub
gh auth login

# Criar repositório
gh repo create tudoaqui --public \
  --description "O super app de Angola - Encontre tudo num só lugar" \
  --homepage "https://tudoaqui.ao" \
  --source=. \
  --remote=origin \
  --push
```

### 2. Configurar Secrets no GitHub

```bash
# Backend Deploy
gh secret set AWS_ACCESS_KEY_ID --body "AKIA_YOUR_KEY"
gh secret set AWS_SECRET_ACCESS_KEY --body "your_secret_key"
gh secret set AWS_ACCOUNT_ID --body "123456789"
gh secret set EC2_STAGING_HOST --body "staging-api.tudoaqui.ao"
gh secret set EC2_PROD_HOST --body "api.tudoaqui.ao"

# Mobile Deploy
gh secret set GOOGLE_PLAY_SERVICE_ACCOUNT_JSON --body @google-play-key.json
gh secret set APPLE_ID --body "seu@email.com"
gh secret set APPLE_APP_SPECIFIC_PASSWORD --body "xxxx-xxxx-xxxx-xxxx"

# Notifications
gh secret set SLACK_WEBHOOK_URL --body "https://hooks.slack.com/..."
```

### 3. Estrutura de branches

```bash
# Main branch - produção
git checkout -b main

# Develop branch - staging
git checkout -b develop

# Feature branches - desenvolvimento
git checkout -b feature/nova-funcionalidade
```

### 4. Primeiro push

```bash
git add .
git commit -m "🚀 Lançamento inicial TudoAqui"
git push origin main
git push origin develop
```

### 5. Ativar GitHub Pages (Web)

```
Settings > Pages > Source: main > /docs
```

---

## Ficheiros Prontos para GitHub

✅ `.gitignore` - Arquivos ignorados  
✅ `.github/workflows/deploy-backend.yml` - CI/CD  
✅ `.github/workflows/deploy-mobile.yml` - Mobile  
✅ `README.md` - Documentação  
✅ `LICENSE` - MIT License  

---

**Próximo**: Execute `terraform init` na pasta `infrastructure/`
