# Guia de Testes KYC - TudoAqui

## Pré-requisitos

- Backend Node.js a executar: `npm run start:dev` na pasta `backend/`
- Base URL: `http://localhost:3000`

---

## 1. Teste de Registro (Auth)

### Request
```bash
curl -X POST http://localhost:3000/auth/register \
  -H "Content-Type: application/json" \
  -d '{
    "nome": "João Silva",
    "email": "joao@tudoaqui.ao",
    "telefone": "+244923123456",
    "senha": "Senha123!",
    "isEmpresa": false
  }'
```

### Response Esperado (201)
```json
{
  "message": "Utilizador registado com sucesso",
  "userId": "uuid-aqui",
  "token": "jwt-token-aqui"
}
```

---

## 2. Teste de Upload BI (KYC - Passo 1)

### Request
```bash
curl -X POST http://localhost:3000/kyc/upload-bi \
  -F "userId=joao-uuid" \
  -F "file=@./test-bi.jpg"
```

### Response Esperado (200)
```json
{
  "message": "BI processado com sucesso",
  "textContent": "JOÃO SILVA, BI 12345678",
  "status": "pendente",
  "documentId": "doc-uuid"
}
```

### O que sucede no backend:
1. Google Vision OCR lê o BI (nome, número, etc.)
2. Se mock mode: simula leitura com valores predefinidos
3. Marca d'água TudoAqui aplicada com Sharp
4. Documento guardado em PostgreSQL `kyc_documentos` table

---

## 3. Teste de Upload Selfie (KYC - Passo 2)

### Request
```bash
curl -X POST http://localhost:3000/kyc/upload-selfie \
  -F "userId=joao-uuid" \
  -F "file=@./test-selfie.jpg"
```

### Response Esperado (200)
```json
{
  "message": "Selfie processada com sucesso",
  "faceDetected": true,
  "livenessScore": 0.85,
  "matchScore": 0.92,
  "status": "aprovado"
}
```

### O que sucede no backend:
1. Google Vision deteta rosto
2. Compara rosto selfie vs rosto do BI (matching)
3. Calcula liveness score (deteta presença real, não foto)
4. Se matchScore > 0.8: auto-aprova KYC
5. Atribui `selo_verificado = true` na tabela `vendedores`

---

## 4. Teste de Upload Alvará (KYC - Passo 3, apenas empresa)

### Request
```bash
curl -X POST http://localhost:3000/kyc/upload-alvara \
  -F "userId=empresa-uuid" \
  -F "file=@./test-alvara.pdf"
```

### Response Esperado (200)
```json
{
  "message": "Alvará validado com sucesso",
  "companyName": "EMPRESA XYZ, LDA",
  "status": "aprovado",
  "businessLicense": "ALV-2024-12345"
}
```

---

## 5. Teste de Obtenção de Status KYC

### Request
```bash
curl -X GET "http://localhost:3000/kyc/status?userId=joao-uuid"
```

### Response Esperado (200)
```json
{
  "userId": "joao-uuid",
  "status": "aprovado",
  "steps": {
    "bi": "concluído",
    "selfie": "concluído",
    "alvara": "não aplicável"
  },
  "seloVerificado": true,
  "createdAt": "2026-01-22T10:30:00Z",
  "approvedAt": "2026-01-22T10:45:00Z"
}
```

---

## 6. Teste Completo (Mock Mode, sem Google Vision)

Se não tiver `GOOGLE_APPLICATION_CREDENTIALS` configurado, o backend entra em **mock mode**:

### Simular Upload BI
```bash
curl -X POST http://localhost:3000/kyc/upload-bi \
  -F "userId=demo-user" \
  -F "file=@./any-image.jpg"
```

Response (mock):
```json
{
  "message": "BI processado com sucesso (MOCK)",
  "textContent": "JOÃO SILVA, BI 0000123456",
  "status": "pendente"
}
```

### Simular Upload Selfie
```bash
curl -X POST http://localhost:3000/kyc/upload-selfie \
  -F "userId=demo-user" \
  -F "file=@./any-image.jpg"
```

Response (mock):
```json
{
  "message": "Selfie processada com sucesso (MOCK)",
  "faceDetected": true,
  "livenessScore": 0.85,
  "matchScore": 0.92,
  "status": "aprovado"
}
```

---

## Testes via Postman

### 1. Criar Collection
- Importar: Backend → Authentication folder
- URL base: `{{base_url}}` = `http://localhost:3000`

### 2. Requests
- **POST /auth/register** - Criar utilizador
- **POST /kyc/upload-bi** - Upload BI
- **POST /kyc/upload-selfie** - Upload Selfie
- **POST /kyc/upload-alvara** - Upload Alvará (empresa)
- **GET /kyc/status** - Obter status KYC

### 3. Pre-request Script (automatizar userId)
```javascript
// Executar após /auth/register para guardar userId
if (pm.response.code === 201) {
  const data = pm.response.json();
  pm.environment.set("userId", data.userId);
  pm.environment.set("authToken", data.token);
}
```

---

## Fluxo Completo (Utilizador Pessoal)

### 1. Registar
```bash
curl -X POST http://localhost:3000/auth/register \
  -H "Content-Type: application/json" \
  -d '{"nome":"João","email":"joao@ao","telefone":"+244923123","senha":"Pass123!","isEmpresa":false}'
```
→ Guardar `userId` e `token`

### 2. Upload BI
```bash
curl -X POST http://localhost:3000/kyc/upload-bi \
  -H "Authorization: Bearer $TOKEN" \
  -F "userId=$USER_ID" \
  -F "file=@./bi.jpg"
```

### 3. Upload Selfie
```bash
curl -X POST http://localhost:3000/kyc/upload-selfie \
  -H "Authorization: Bearer $TOKEN" \
  -F "userId=$USER_ID" \
  -F "file=@./selfie.jpg"
```

### 4. Consultar Status
```bash
curl -X GET "http://localhost:3000/kyc/status?userId=$USER_ID" \
  -H "Authorization: Bearer $TOKEN"
```

→ Se `status: "aprovado"` e `seloVerificado: true`, KYC completo! ✅

---

## Troubleshooting

### 400 Bad Request
```
"error": "userId é obrigatório"
```
**Solução:** Adicionar `-F "userId=demo-user"` ao curl

### 404 Not Found
```
"error": "Endpoint não encontrado"
```
**Solução:** Verificar se backend está a executar (`npm run start:dev`)

### 500 Internal Server Error
```
"error": "Google Vision API error: Permission denied"
```
**Solução:** Ativar mock mode ou configurar `GOOGLE_APPLICATION_CREDENTIALS`

---

## Ficheiros de Teste

Descarregar exemplos de teste:
- `/backend/test-kyc-full.ps1` - Script PowerShell completo
- `/backend/test-kyc-simple.ps1` - Teste rápido
- `/test-kyc-1-3.py` - Python com requests

