# Configuração de Permissões - TudoAqui KYC

## Android (android/app/src/main/AndroidManifest.xml)

As seguintes permissões foram adicionadas:

### Câmara e Galeria
- `android.permission.CAMERA` - Capturar fotos do BI e selfie
- `android.permission.READ_EXTERNAL_STORAGE` - Ler fotos da galeria (Alvará)
- `android.permission.WRITE_EXTERNAL_STORAGE` - Guardar imagens processadas

### Localização
- `android.permission.ACCESS_FINE_LOCATION` - GPS preciso para "Perto de Mim"
- `android.permission.ACCESS_COARSE_LOCATION` - Localização aproximada

### Internet
- `android.permission.INTERNET` - Comunicação com backend

**Nota:** Em Android 6.0+, as permissões são pedidas em runtime. O pacote `image_picker` e `geolocator` gerem isto automaticamente.

---

## iOS (ios/Runner/Info.plist)

As seguintes chaves NSLocalizedDescription foram adicionadas:

### Câmara
- `NSCameraUsageDescription` - Explicação para captura de BI/selfie

### Galeria
- `NSPhotoLibraryUsageDescription` - Acesso à biblioteca de fotos
- `NSPhotoLibraryAddUsageDescription` - Guardar fotos verificadas

### Localização
- `NSLocationWhenInUseUsageDescription` - Localização durante utilização
- `NSLocationAlwaysAndWhenInUseUsageDescription` - Localização em tempo real

**Nota:** Em iOS, as mensagens aparecem quando o app pede a permissão.

---

## Testar Permissões

### Android
```bash
cd android && ./gradlew installDebug
# Permitir câmara e galeria quando o app pedir
```

### iOS
```bash
cd ios && pod install
open ios/Runner.xcworkspace
# Executar em Xcode (Cmd+R)
# Permitir câmara quando o app pedir
```

### Web (não requer manifesto específico)
- `image_picker` usa File Input (galeria)
- Câmara pode ser controlada via navegador (permissions.camera)

---

## Fluxo de Permissões no App

1. Utilizador toca "Tirar Foto do BI"
2. `image_picker` pede `CAMERA` (Android) ou mostra `NSCameraUsageDescription` (iOS)
3. Utilizador aceita e câmara abre
4. Foto é capturada e validada com `google_ml_kit` (OCR)
5. Upload para backend via HTTP/multipart
6. Próximo passo: Selfie (repetir com câmara frontal)

---

## Segurança

- Imagens **não são guardadas** no dispositivo por padrão (apenas em memória temporária)
- OCR ocorre **no dispositivo** (google_ml_kit local) antes de envio
- Backend recebe apenas a imagem (será processada com Google Vision API ou mock)
- Marca d'água automática aplicada no backend

