# TESTE MANUAL POSTMAN - KYC 1-3

## ⚙️ Setup Inicial

1. **Instalar Postman:** https://www.postman.com/downloads/
2. **Backend ativo em:** http://127.0.0.1:3000/api/v1

---

## 📋 PASSO 1: Registar Utilizador

**Método:** POST  
**URL:** `http://127.0.0.1:3000/api/v1/auth/register`  
**Headers:** Content-Type: application/json

**Body (JSON):**
```json
{
  "email": "vendedor123@tudoaqui.ao",
  "senha": "Senha123!",
  "nome": "João da Silva",
  "telefone": "+244912345678",
  "tipo": "vendedor"
}
```

**Resposta Esperada (201):**
```json
{
  "message": "Utilizador registado com sucesso",
  "id": "uuid-do-usuario",
  "email": "vendedor123@tudoaqui.ao",
  "access_token": "eyJhbGc...token...completo"
}
```

**✓ Guardar:**
- `id` (User ID)
- `access_token` (para próximos passos)

---

## 📋 PASSO 2: Verificar Status KYC

**Método:** GET  
**URL:** `http://127.0.0.1:3000/api/v1/kyc/status/{USER_ID}`  
**Headers:** 
- Authorization: Bearer {ACCESS_TOKEN}

**Resposta Esperada (200):**
```json
{
  "kycStatus": "pendente",
  "seloVerificado": false,
  "biNumero": null,
  "fotoBI": null,
  "fotoSelfie": null,
  "alvaraUrl": null
}
```

---

## 📋 PASSO 3: Validar Endpoint Upload BI

**Método:** POST  
**URL:** `http://127.0.0.1:3000/api/v1/kyc/upload-bi`  
**Headers:**
- Authorization: Bearer {ACCESS_TOKEN}

**Body (form-data):**
- Key: `file`
- Value: Escolher ficheiro de imagem (PNG, JPG - máx 5MB)

**Nota:** O BI será automaticamente com watermark "TudoAqui"

---

## 🎯 CHECKLIST SUCESSO

✓ Passo 1: Utilizador criado com ID único  
✓ Passo 2: kycStatus = "pendente", seloVerificado = false  
✓ Passo 3: Upload endpoint válido (status 200/201)

---

## 🔧 Dicas Postman

1. **Guardar token para reutilizar:**
   - Usar Postman Environment para armazenar `{{token}}` e `{{userId}}`
   - Copiar access_token da resposta do Passo 1
   - Cole em: Environments → Create "TudoAqui Dev" → Variables

2. **Testar com dados variados:**
   - Email deve ser único a cada teste
   - Usar `novo-email-$(date).@tudoaqui.ao` para evitar conflitos

---

## ❓ Troubleshooting

| Erro | Solução |
|------|---------|
| Connection refused | Backend não está rodando. Execute: `cd backend && npm run start:dev` |
| 400 Bad Request | Verifique JSON syntax, campos obrigatórios |
| 401 Unauthorized | Bearer token inválido ou expirado |
| 409 Conflict | Email já existe. Use um novo |
| 413 Payload Too Large | Imagem > 5MB. Comprimir e tentar novamente |

---

## 📊 Expected Flow

```
1. POST /auth/register
   → 201 Created, recebe access_token

2. GET /kyc/status/{id}
   → 200 OK, kycStatus="pendente"

3. POST /kyc/upload-bi (com imagem)
   → 200 OK, imagem com watermark "TudoAqui" guardada
```

---

**Data:** 21/01/2026  
**Backend:** NestJS + TypeScript  
**Database:** PostgreSQL (Docker)
