# TudoAqui - Super App Marketplace Angola

**Lema:** "Encontre tudo num só lugar"

## 🚀 Sobre o Projeto

TudoAqui (código interno: Mixeiro) é um super app marketplace agregador para o mercado angolano que conecta utilizadores a produtos e serviços através de uma única plataforma segura.

### Categorias
- 🏠 Imobiliária (Venda/Aluguer)
- 🚗 Automóveis (Venda/Aluguer)
- 📍 Terrenos
- 🍴 Restaurantes (Integração Tupuca/Mano)
- 🌴 Turismo
- 🚕 Táxi (Heetch/Yango)
- 🛡️ Seguros

## 🛠️ Tech Stack

- **Frontend:** Flutter/Dart (multiplataforma: Android + iOS)
- **Backend:** Node.js
- **Databases:** PostgreSQL + Firebase
- **Integrações:** Tupuca (logística), Heetch/Yango (mobilidade), Multicaixa Express/GPO (pagamentos)
- **Segurança:** KYC com IA, reconhecimento facial, validação de BI

## 📱 Estrutura do Projeto

```
lib/
├── main.dart                              # Ponto de entrada da app
├── screens/
│   ├── home_marketplace.dart              # Ecrã principal com categorias
│   ├── restaurantes/
│   │   └── lista_restaurantes.dart        # Lista e menu de restaurantes
│   └── verificacao_documentos.dart        # KYC multi-passo (BI, Selfie, Alvará)
└── utils/
    └── constants.dart                     # Cores, endpoints, dimensões
```

## 🎨 Design System

- **Cor Primária:** `#0052CC` (Azul Cobalto - representa confiança)
- **Padrão:** Material Design com português (PT-AO)
- **Componentes:** Cards com bordas arredondadas (15px), botões altura 55px

## ⚙️ Como Executar

### Pré-requisitos
- Flutter SDK 3.0+
- Dart 3.0+
- Android Studio ou Xcode

### Comandos
```bash
# Instalar dependências
flutter pub get

# Executar em emulador/dispositivo
flutter run

# Build para produção
flutter build apk --release         # Android
flutter build ipa --release         # iOS (requer macOS)
```

## 🔐 Segurança

- **KYC Obrigatório:** Validação de BI com reconhecimento facial (Liveness Detection)
- **Selo de Verificado:** Apenas vendedores aprovados podem anunciar
- **Marca d'água:** Todas as fotos de documentos recebem watermark "TudoAqui"
- **Chat Interno:** Protege números de telefone dos utilizadores

## 📋 Roadmap (8 Meses)

### Fase 1: Fundação (Meses 1-2) ✅
- [x] Sistema de autenticação
- [x] Módulo KYC multi-passo
- [x] Home com categorias

### Fase 2: Marketplace (Meses 3-4)
- [ ] Listagens de imóveis e automóveis
- [ ] Geolocalização "perto de mim"
- [ ] Chat interno Firebase

### Fase 3: Integrações (Meses 5-6)
- [ ] API Tupuca (logística)
- [ ] Heetch/Yango (taxis)
- [ ] Multicaixa Express + GPO (pagamentos)

### Fase 4: Turismo (Mês 7)
- [ ] Booking de restaurantes
- [ ] Pacotes turísticos
- [ ] Simulação de seguros

### Fase 5: Lançamento (Mês 8)
- [ ] Beta test em Luanda
- [ ] Campanha de marketing

## 💰 Modelo de Negócio

1. **Subscrição Premium:** Destaque para empresas
2. **Taxa de Transação:** 2-5% em reservas
3. **Publicidade:** Bancos e seguradoras
4. **Comissão Logística:** Entregas via Tupuca

## 📞 Suporte

Para mais informações, consulte [.github/copilot-instructions.md](.github/copilot-instructions.md)

---

**Desenvolvido para o mercado angolano 🇦🇴**
