# 🔒 Guia de Segurança - Secrets e Credenciais

**IMPORTANTE**: Nunca commitar arquivos com credenciais reais!

## ✅ Ficheiros Seguros (Commitar)

- `.env.example` - Template vazio
- `.gitignore` - Ignora arquivos sensíveis
- `infrastructure/terraform.tfvars.example` - Template Terraform
- Documentação markdown

## ❌ Ficheiros com Segredos (NÃO Commitar)

- `.env` - Variáveis reais
- `infrastructure/terraform.tfvars` - Valores reais
- `~/.ssh/tudoaqui-aws` - Chave SSH privada
- `~/tudoaqui-release.jks` - Keystore Android
- `certificates/secrets.txt` - Secrets JWT/DB
- `google-play-key.json` - Google Play credentials

## 🔧 Como Gerenciar Secrets

### Local Development

```bash
# Criar .env local (nunca commitar)
cp .env.example .env
# Editar .env com valores reais

# Terraform local
cp infrastructure/terraform.tfvars.example infrastructure/terraform.tfvars
# Editar terraform.tfvars com valores reais
```

### GitHub Actions (CI/CD)

```bash
# Adicionar secrets via CLI
gh secret set JWT_SECRET --body "seu_secret_aqui"
gh secret set DB_PASSWORD --body "sua_senha_aqui"
gh secret set AWS_ACCESS_KEY_ID --body "seu_access_key"
```

### AWS (Produção)

```bash
# Usar AWS Secrets Manager
aws secretsmanager create-secret \
  --name tudoaqui/prod/jwt-secret \
  --secret-string "seu_jwt_secret"

# Ou AWS Parameter Store
aws ssm put-parameter \
  --name /tudoaqui/prod/db-password \
  --value "sua_senha" \
  --type SecureString
```

## 🛡️ Boas Práticas

1. **Rotate secrets regularmente** (a cada 90 dias)
2. **Use strong passwords** (mínimo 32 caracteres)
3. **Enable MFA** em todas as contas
4. **Auditar acesso** a secrets
5. **Usar IAM roles** em vez de access keys
6. **Encriptar em transit** (HTTPS/TLS)
7. **Encriptar at rest** (AWS KMS)

## 🔑 Seus Secrets (Guardar com Segurança)

Ficheiro: `certificates/secrets.txt`

```
✅ Guardado em: c:\xampp\htdocs\TudoAqui\certificates\secrets.txt
✅ Este ficheiro está em .gitignore
✅ Fazer backup seguro deste ficheiro
```

---

**Leia**: https://owasp.org/www-project-secure-coding-practices/
