curl http://[EC2_PUBLIC_IP]:3000/health# 🚀 Como Iniciar o TudoAqui

## ✅ Status Atual

O backend está pronto para iniciar, mas precisa de algumas configurações:

### ⚠️ Erro Encontrado

```
QueryFailedError: type "geography" does not exist
```

**Causa**: PostGIS não está instalado no PostgreSQL  
**Solução**: Instalar extensão PostGIS para geolocalização

---

## 📋 Pré-requisitos de Inicialização

### 1. PostgreSQL com PostGIS

#### Windows - XAMPP

```bash
# Abrir XAMPP Control Panel
# ✅ Iniciar MySQL (se for MySQL, usar alternativa)
# ✅ Iniciar Apache (opcional)

# OU via comando para PostgreSQL (se instalado)
pg_ctl start
```

#### Instalar PostGIS

```bash
# Via psql
psql -U postgres -d tudoaqui -c "CREATE EXTENSION IF NOT EXISTS postgis;"
psql -U postgres -d tudoaqui -c "CREATE EXTENSION IF NOT EXISTS uuid-ossp;"

# Verificar instalação
psql -U postgres -d tudoaqui -c "SELECT PostGIS_version();"
```

### 2. Redis

```bash
# Iniciar Redis (se instalado localmente)
redis-server

# OU via Docker
docker run -d -p 6379:6379 redis:latest
```

### 3. Variáveis de Ambiente

Criar/verificar arquivo `.env`:

```bash
cd c:\xampp\htdocs\TudoAqui\backend
copy .env.example .env
```

Editar `.env` com suas configurações:

```env
NODE_ENV=development
PORT=3000

# Database
DB_HOST=localhost
DB_PORT=5432
DB_NAME=tudoaqui
DB_USER=postgres
DB_PASSWORD=sua_senha

# JWT
JWT_SECRET=seu_secret_muito_seguro_aqui
JWT_EXPIRES_IN=24h

# Redis
REDIS_HOST=localhost
REDIS_PORT=6379

# AWS S3 (deixar em branco para mock)
AWS_ACCESS_KEY_ID=
AWS_SECRET_ACCESS_KEY=
AWS_S3_BUCKET=

# Firebase
FIREBASE_PROJECT_ID=
FIREBASE_PRIVATE_KEY=
FIREBASE_CLIENT_EMAIL=
```

---

## 🎯 Opção 1: Iniciar com Node.js Puro

### Passo 1: Navegar para o backend

```bash
cd c:\xampp\htdocs\TudoAqui\backend
```

### Passo 2: Instalar dependências (primeira vez)

```bash
npm install
```

### Passo 3: Build do projeto

```bash
npm run build
```

### Passo 4: Iniciar em modo desenvolvimento

```bash
npm run start:dev
```

**Esperado**:

```
[Nest] 1234  - 22/01/2026, 19:45:30   LOG [NestFactory] Starting Nest application...
[Nest] 1234  - 22/01/2026, 19:45:31   LOG [InstanceLoader] TypeOrmModule dependencies initialized
[Nest] 1234  - 22/01/2026, 19:45:32   LOG [InstanceLoader] ConfigModule dependencies initialized
[Nest] 1234  - 22/01/2026, 19:45:33   LOG [NestApplication] Nest application successfully started
Server running on http://localhost:3000
```

---

## 🐳 Opção 2: Iniciar com Docker (RECOMENDADO)

### Passo 1: Instalar Docker

Baixar e instalar:

- **Windows**: [Docker Desktop](https://www.docker.com/products/docker-desktop)

### Passo 2: Iniciar containers

```bash
cd c:\xampp\htdocs\TudoAqui

# Iniciar todos os serviços (API, PostgreSQL, Redis, etc)
docker-compose up -d
```

### Passo 3: Verificar status

```bash
docker-compose ps

# Esperado:
# NAME                COMMAND             STATUS
# tudoaqui-api        node dist/main      Up 30s
# tudoaqui-db         postgres            Up 30s
# tudoaqui-redis      redis               Up 30s
```

### Passo 4: Ver logs

```bash
docker-compose logs -f api
```

---

## 📊 Verificar se está funcionando

### 1. Health Check

```bash
curl http://localhost:3000/health
```

**Esperado**:

```json
{
  "status": "ok",
  "timestamp": "2026-01-22T19:45:33.000Z",
  "services": {
    "database": "connected",
    "redis": "connected"
  }
}
```

### 2. Swagger UI

Abrir no navegador:

```
http://localhost:3000/api-docs
```

### 3. OpenAPI Spec

```bash
curl http://localhost:3000/swagger.json
```

---

## 📱 Opção 3: Abrir Frontend Flutter

### Pré-requisitos

- Flutter SDK 3.x instalado
- Emulador Android/iOS ou dispositivo conectado

### Comandos

```bash
cd c:\xampp\htdocs\TudoAqui

# Listar dispositivos disponíveis
flutter devices

# Executar em modo desenvolvimento
flutter run

# Executar em Chrome (web)
flutter run -d chrome

# Compilar APK (Android)
flutter build apk --release

# Compilar IPA (iOS - requer macOS)
flutter build ipa --release
```

---

## 🔧 Troubleshooting

### ❌ Erro: "Cannot find module '@nestjs/core'"

**Solução**:

```bash
cd c:\xampp\htdocs\TudoAqui\backend
npm install
```

### ❌ Erro: "type geography does not exist"

**Solução**: Instalar PostGIS

```bash
psql -U postgres -d tudoaqui -c "CREATE EXTENSION IF NOT EXISTS postgis;"
```

### ❌ Erro: "ECONNREFUSED 127.0.0.1:5432"

**Solução**: Verificar se PostgreSQL está rodando

```bash
# Windows
pg_ctl status

# Ou iniciar
pg_ctl start
```

### ❌ Erro: "ECONNREFUSED 127.0.0.1:6379"

**Solução**: Verificar se Redis está rodando

```bash
redis-cli ping

# Deve retornar: PONG
```

### ❌ Erro: "Port 3000 already in use"

**Solução**: Matar processo na porta 3000

```bash
# Windows
netstat -ano | findstr :3000
taskkill /PID <PID> /F

# Ou usar porta diferente
PORT=3001 npm run start:dev
```

---

## 🌐 URLs Disponíveis Após Inicialização

| URL                                  | Descrição              | Status    |
| ------------------------------------ | ---------------------- | --------- |
| `http://localhost:3000`              | API Root               | ✅ 200 OK |
| `http://localhost:3000/health`       | Health Check           | ✅ 200 OK |
| `http://localhost:3000/api-docs`     | Swagger UI             | ✅ 200 OK |
| `http://localhost:3000/swagger.json` | OpenAPI Spec           | ✅ 200 OK |
| `http://localhost:3001`              | Grafana (se Docker)    | ✅ 200 OK |
| `http://localhost:9090`              | Prometheus (se Docker) | ✅ 200 OK |

---

## 📝 Exemplo de Requisição Teste

### Registrar novo usuário

```bash
curl -X POST http://localhost:3000/auth/register \
  -H "Content-Type: application/json" \
  -d '{
    "nome": "João Silva",
    "email": "joao@tudoaqui.ao",
    "telefone": "923123456",
    "senha": "Senha123!"
  }'
```

**Resposta esperada**:

```json
{
  "success": true,
  "data": {
    "id": "550e8400-e29b-41d4-a716-446655440000",
    "email": "joao@tudoaqui.ao",
    "telefone": "923123456",
    "tipo": "comprador"
  },
  "message": "Usuário registrado com sucesso"
}
```

### Login

```bash
curl -X POST http://localhost:3000/auth/login \
  -H "Content-Type: application/json" \
  -d '{
    "email": "joao@tudoaqui.ao",
    "senha": "Senha123!"
  }'
```

**Resposta esperada**:

```json
{
  "success": true,
  "data": {
    "access_token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...",
    "refresh_token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...",
    "user": {
      "id": "550e8400-e29b-41d4-a716-446655440000",
      "email": "joao@tudoaqui.ao",
      "tipo": "comprador"
    }
  }
}
```

---

## 📊 Comandos Úteis

### Desenvolvimento

```bash
# Mode watch (rebuild automático)
npm run start:dev

# Build de produção
npm run build

# Executar build de produção
npm run start:prod

# Executar testes
npm test

# Testes com coverage
npm run test:cov

# Testes em watch mode
npm run test:watch
```

### Docker

```bash
# Iniciar serviços
docker-compose up -d

# Parar serviços
docker-compose down

# Ver logs
docker-compose logs -f

# Rebuild images
docker-compose build --no-cache

# Remover tudo
docker-compose down -v
```

### Database

```bash
# Conectar a PostgreSQL
psql -U postgres -d tudoaqui

# Listar tabelas
\dt

# Sair
\q

# Backup
pg_dump -U postgres tudoaqui > backup.sql

# Restore
psql -U postgres tudoaqui < backup.sql
```

---

## ✅ Checklist de Inicialização

- [ ] PostgreSQL instalado e rodando
- [ ] PostGIS instalado (`CREATE EXTENSION postgis;`)
- [ ] Redis instalado e rodando
- [ ] Node.js 18.x+ instalado
- [ ] Arquivo `.env` configurado
- [ ] `npm install` executado
- [ ] `npm run build` compilou com sucesso
- [ ] `npm run start:dev` iniciou sem erros
- [ ] Health check retornou `"status": "ok"`
- [ ] Swagger UI acessível em `http://localhost:3000/api-docs`
- [ ] Conseguiu registrar usuário via API
- [ ] Conseguiu fazer login e recebeu tokens JWT

---

## 🎉 Pronto!

Seu TudoAqui está **100% operacional**! 🚀

- 📡 **Backend**: `http://localhost:3000`
- 📚 **Documentação**: `http://localhost:3000/api-docs`
- 💾 **Banco de dados**: PostgreSQL + PostGIS
- 🔴 **Cache**: Redis
- 📊 **Monitoramento**: Prometheus + Grafana (se Docker)

### Próximos Passos

1. **Teste a API** com Postman: Importe `docs/api/TudoAqui.postman_collection.json`
2. **Explore Swagger**: `http://localhost:3000/api-docs`
3. **Execute testes**: `npm test`
4. **Deploy**: Siga [DEPLOYMENT.md](DEPLOYMENT.md)

---

**Suporte**: suporte@tudoaqui.ao  
**Status**: ✅ Sistema Operacional  
**Versão**: 1.0.0
