# TESTES KYC - COMANDOS MANUAIS
# Copiar e colar cada bloco no PowerShell

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "TESTE 1: REGISTAR UTILIZADOR" -ForegroundColor Yellow
Write-Host "========================================" -ForegroundColor Cyan

$body = '{"email":"teste@tudoaqui.ao","senha":"Senha123!","nome":"Teste User","telefone":"+244912345678","tipo":"vendedor"}'

$response = Invoke-RestMethod -Uri "http://localhost:3000/api/v1/auth/register" -Method POST -ContentType "application/json" -Body $body

$response | ConvertTo-Json
$userId = $response.id
$token = $response.access_token

Write-Host ""
Write-Host "User ID: $userId" -ForegroundColor Green
Write-Host "Token salvo!" -ForegroundColor Green
Write-Host ""

# ========================================

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "TESTE 2: STATUS KYC INICIAL" -ForegroundColor Yellow
Write-Host "========================================" -ForegroundColor Cyan

$headers = @{Authorization = "Bearer $token"}
$status = Invoke-RestMethod -Uri "http://localhost:3000/api/v1/kyc/status/$userId" -Method GET -Headers $headers

Write-Host "kycStatus: $($status.kycStatus)" -ForegroundColor Cyan
Write-Host "seloVerificado: $($status.seloVerificado)" -ForegroundColor Cyan
Write-Host ""

# ========================================

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "TESTE 3: CRIAR IMAGEM BI" -ForegroundColor Yellow
Write-Host "========================================" -ForegroundColor Cyan

Add-Type -AssemblyName System.Drawing
$img = New-Object System.Drawing.Bitmap(400,250)
$g = [System.Drawing.Graphics]::FromImage($img)
$g.Clear([System.Drawing.Color]::LightBlue)
$font = New-Object System.Drawing.Font("Arial",16)
$g.DrawString("BI TESTE 123456789", $font, [System.Drawing.Brushes]::Black, 50, 100)
$g.Dispose()
$tempBi = "$env:TEMP\test_bi.png"
$img.Save($tempBi)
$img.Dispose()

Write-Host "Imagem criada: $tempBi" -ForegroundColor Green
Write-Host ""

# ========================================

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "TESTE 4: CRIAR IMAGEM SELFIE" -ForegroundColor Yellow
Write-Host "========================================" -ForegroundColor Cyan

$img = New-Object System.Drawing.Bitmap(300,300)
$g = [System.Drawing.Graphics]::FromImage($img)
$g.Clear([System.Drawing.Color]::Beige)
$pen = New-Object System.Drawing.Pen([System.Drawing.Color]::Black, 2)
$g.DrawEllipse($pen, 50, 50, 200, 200)
$g.Dispose()
$pen.Dispose()
$tempSelfie = "$env:TEMP\test_selfie.png"
$img.Save($tempSelfie)
$img.Dispose()

Write-Host "Selfie criada: $tempSelfie" -ForegroundColor Green
Write-Host ""

# ========================================

Write-Host "========================================" -ForegroundColor Yellow
Write-Host "RESUMO DOS TESTES 1-4" -ForegroundColor Yellow
Write-Host "========================================" -ForegroundColor Yellow
Write-Host ""
Write-Host "✅ Teste 1: Utilizador registado (ID: $userId)"
Write-Host "✅ Teste 2: Status KYC verificado (kycStatus: pendente)"
Write-Host "✅ Teste 3: Imagem BI criada em $tempBi"
Write-Host "✅ Teste 4: Imagem Selfie criada em $tempSelfie"
Write-Host ""
Write-Host "PRÓXIMOS COMANDOS (UPLOAD + ANÁLISE):" -ForegroundColor Cyan
Write-Host ""
Write-Host "# Para enviar BI (requer multipart - usar Postman):"
Write-Host "POST http://localhost:3000/api/v1/kyc/upload-bi"
Write-Host "Headers: Authorization: Bearer $token"
Write-Host "Body: form-data, file=$tempBi"
Write-Host ""
Write-Host "# Para analisar Rekognition:"
Write-Host '$analyzeBody = "{\"userId\":\"' + $userId + '\"}"'
Write-Host 'Invoke-RestMethod -Uri "http://localhost:3000/api/v1/kyc/analyze" -Method POST -Headers @{Authorization="Bearer $token"} -ContentType "application/json" -Body $analyzeBody'
