# API Documentation - TudoAqui

## 📚 Acesso à Documentação Interativa (Swagger UI)

A documentação interativa da API está disponível em:

```
Local Development:  http://localhost:3000/api-docs
Production:         https://api.tudoaqui.ao/api-docs
```

### Recursos Disponíveis

- **Swagger UI**: Interface interativa para explorar e testar todos os endpoints
- **OpenAPI 3.0**: Especificação completa em `swagger.json`
- **Autorização Bearer**: Suporte integrado para autenticação JWT no Swagger UI

---

## 🔗 Base URLs

```
Production:  https://api.tudoaqui.ao/api/v1
Development: http://localhost:3000/api/v1
```

---

## 🔐 Autenticação

### Bearer Token
Maioria dos endpoints requer autenticação via **Bearer Token**:

```
Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...
```

### Endpoints Públicos (sem autenticação)
- ✅ `POST /auth/register`
- ✅ `POST /auth/login`
- ✅ `GET /imoveis` (listagem)
- ✅ `GET /turismo/pacotes`
- ✅ `GET /restaurantes`
- ✅ `GET /alojamentos`
- ✅ `GET /eventos/salas`
- ✅ `GET /health`
- ✅ `GET /metrics`

---

## 📊 Rate Limiting

| Endpoint Type | Limit | Window |
|--------------|-------|--------|
| Auth endpoints (`/auth/*`) | 5 requests | 15 minutes |
| General API endpoints | 100 requests | 15 minutes |
| Health/Metrics | Unlimited | - |

Quando o limite é excedido, retorna `429 Too Many Requests`.

---

## 📤 Response Format

Todas as respostas seguem este formato padronizado:

### Success Response
```json
{
  "success": true,
  "data": {},
  "message": "Operação realizada com sucesso"
}
```

### Error Response
```json
{
  "success": false,
  "error": "Descrição do erro"
}
```

---

## 🗺️ Endpoints Overview

### 🔐 Autenticação
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| POST | `/auth/register` | Registrar novo usuário | ❌ |
| POST | `/auth/login` | Fazer login | ❌ |
| POST | `/auth/verify-phone` | Verificar telefone (2FA) | ✅ |
| GET | `/auth/me` | Obter perfil autenticado | ✅ |
| PUT | `/auth/perfil` | Atualizar perfil | ✅ |
| POST | `/auth/logout` | Fazer logout | ✅ |

### 🏠 Imóveis
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| GET | `/imoveis` | Listar imóveis com filtros | ❌ |
| POST | `/imoveis` | Criar novo imóvel | ✅ |
| GET | `/imoveis/:id` | Obter detalhes do imóvel | ❌ |
| GET | `/imoveis/meus` | Meus imóveis | ✅ |

### 🚗 Transporte
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| POST | `/transporte/viagens` | Solicitar viagem/corrida | ✅ |
| POST | `/transporte/viagens/:id/confirmar` | Confirmar viagem | ✅ |
| GET | `/transporte/viagens/:id` | Rastrear viagem em tempo real | ✅ |

### 🌴 Turismo
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| GET | `/turismo/pacotes` | Listar pacotes turísticos | ❌ |
| POST | `/turismo/reservas` | Reservar pacote | ✅ |
| GET | `/turismo/reservas` | Minhas reservas | ✅ |

### 🎉 Eventos
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| GET | `/eventos/salas` | Listar salas para eventos | ❌ |
| POST | `/eventos/salas/reservar` | Reservar sala | ✅ |

### 🎫 Ingressos
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| POST | `/ingressos/comprar` | Comprar ingressos | ✅ |
| POST | `/ingressos/validar` | Validar ingresso (scanner) | ✅ |

### 🍽️ Restaurantes
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| GET | `/restaurantes` | Listar restaurantes | ❌ |
| POST | `/restaurantes/reservar` | Reservar mesa | ✅ |
| POST | `/restaurantes/pedido` | Fazer pedido delivery | ✅ |

### 🏨 Alojamentos
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| GET | `/alojamentos` | Listar hotéis e alojamentos | ❌ |
| POST | `/alojamentos/reservar` | Reservar alojamento | ✅ |

### 💳 Pagamentos
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| POST | `/pagamentos/processar` | Processar pagamento | ✅ |
| POST | `/pagamentos/confirmar` | Confirmar com comprovativo | ✅ |
| GET | `/pagamentos/historico` | Histórico de transações | ✅ |
| GET | `/pagamentos/:id` | Detalhe da transação | ✅ |
| DELETE | `/pagamentos/:id` | Cancelar transação | ✅ |

### 📊 Observabilidade
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|:-------------:|
| GET | `/health` | Health check rápido | ❌ |
| GET | `/health/detailed` | Health check detalhado | ❌ |
| GET | `/metrics` | Métricas Prometheus | ❌ |

---

## 💳 Métodos de Pagamento

| Método | Descrição | Minimum |
|--------|-----------|---------|
| **Multicaixa** | ATM Angola, referência de pagamento | 100 AOA |
| **Cartão de Crédito** | Via Stripe, integração segura | 100 AOA |
| **Transferência Bancária** | Dados BAI/NIB/IBAN | 100 AOA |
| **Dinheiro** | Pagamento na entrega | 100 AOA |

---

## 🔍 Filtros Disponíveis

### Imóveis
```
tipo: casa, apartamento, terreno, escritorio
finalidade: venda, aluguel, temporada
preco_min, preco_max
localizacao
quartos, banheiros
area_min, area_max
ordenar: preco_asc, preco_desc, data_desc, avaliacao_desc
```

### Pagamentos
```
status: pendente, confirmada, cancelada
modulo: imoveis, transporte, turismo, eventos, ingressos, restaurantes, alojamentos
```

---

## 📝 Exemplos de Uso

### Autenticação

#### Registrar Usuário
```bash
curl -X POST http://localhost:3000/api/v1/auth/register \
  -H "Content-Type: application/json" \
  -d '{
    "nome": "João Silva",
    "email": "joao@example.com",
    "telefone": "923456789",
    "senha": "SenhaForte123",
    "tipo_usuario": "vendedor"
  }'
```

**Resposta:**
```json
{
  "success": true,
  "data": {
    "user": {
      "id": "550e8400-e29b-41d4-a716-446655440000",
      "nome": "João Silva",
      "email": "joao@example.com"
    },
    "token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9..."
  },
  "message": "Usuário registrado com sucesso"
}
```

#### Fazer Login
```bash
curl -X POST http://localhost:3000/api/v1/auth/login \
  -H "Content-Type: application/json" \
  -d '{
    "email": "joao@example.com",
    "senha": "SenhaForte123"
  }'
```

#### Usar Token em Requisições
```bash
curl -X GET http://localhost:3000/api/v1/auth/me \
  -H "Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9..."
```

---

### Transporte (Solicitar Viagem)

```bash
curl -X POST http://localhost:3000/api/v1/transporte/viagens \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer {token}" \
  -d '{
    "origem": {
      "latitude": -8.8383,
      "longitude": 13.2344
    },
    "destino": {
      "latitude": -8.8150,
      "longitude": 13.2302
    }
  }'
```

**Resposta:**
```json
{
  "success": true,
  "data": {
    "cotacoes": [
      {
        "fornecedor": "Tupuca",
        "preco": 1500,
        "tempo_estimado": 15,
        "motoristas_disponiveis": 8
      },
      {
        "fornecedor": "Yango",
        "preco": 1350,
        "tempo_estimado": 12,
        "motoristas_disponiveis": 12
      }
    ]
  },
  "message": "Cotações obtidas com sucesso"
}
```

---

### Turismo (Reservar Pacote)

```bash
curl -X POST http://localhost:3000/api/v1/turismo/reservas \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer {token}" \
  -d '{
    "pacote_id": "550e8400-e29b-41d4-a716-446655440000",
    "data_inicio": "2026-02-15",
    "numero_pessoas": 2
  }'
```

---

### Ingressos (Comprar)

```bash
curl -X POST http://localhost:3000/api/v1/ingressos/comprar \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer {token}" \
  -d '{
    "evento_id": "550e8400-e29b-41d4-a716-446655440000",
    "quantidade": 2
  }'
```

**Resposta:**
```json
{
  "success": true,
  "data": {
    "ingressos": [
      {
        "id": "ingresso-1-uuid",
        "codigo_qr": "base64_encoded_qr_code",
        "evento": "Show Musical - Anselmo Ralph"
      },
      {
        "id": "ingresso-2-uuid",
        "codigo_qr": "base64_encoded_qr_code",
        "evento": "Show Musical - Anselmo Ralph"
      }
    ],
    "total": 10000
  },
  "message": "Ingressos comprados com sucesso"
}
```

---

### Pagamentos (Processar)

```bash
curl -X POST http://localhost:3000/api/v1/pagamentos/processar \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer {token}" \
  -d '{
    "item_id": "550e8400-e29b-41d4-a716-446655440000",
    "modulo": "imoveis",
    "valor": 50000000,
    "metodo_pagamento": "multicaixa"
  }'
```

---

## ⚠️ Códigos de Erro

| Código | Significado |
|--------|-------------|
| 200 | OK - Sucesso |
| 201 | Created - Recurso criado |
| 400 | Bad Request - Validação falhou |
| 401 | Unauthorized - Token inválido/expirado |
| 403 | Forbidden - Acesso negado (ex: não vendedor) |
| 404 | Not Found - Recurso não existe |
| 429 | Too Many Requests - Limite de taxa excedido |
| 500 | Internal Server Error - Erro no servidor |
| 503 | Service Unavailable - Banco de dados ou cache offline |

---

## 🏥 Health Checks

### Health Rápido (para Load Balancer)
```bash
curl http://localhost:3000/health
```

**Resposta:**
```json
{
  "status": "ok"
}
```

### Health Detalhado (para Debugging)
```bash
curl http://localhost:3000/health/detailed
```

**Resposta:**
```json
{
  "status": "healthy",
  "timestamp": "2026-01-22T10:30:00Z",
  "checks": {
    "database": {
      "status": "healthy",
      "response_time_ms": 5,
      "message": "Database is responsive"
    },
    "redis": {
      "status": "healthy",
      "response_time_ms": 2,
      "message": "Redis is responsive"
    },
    "storage": {
      "status": "healthy",
      "available_gb": 450,
      "message": "Storage is accessible"
    }
  }
}
```

### Métricas Prometheus
```bash
curl http://localhost:3000/metrics
```

Retorna métricas em formato Prometheus para importar em Grafana.

---

## 🛠️ Gerar SDKs Automaticamente

Usar OpenAPI Generator:

```bash
# Node.js Client
npx openapi-generator-cli generate -i swagger.json -g javascript -o ./sdk/js

# Python Client
npx openapi-generator-cli generate -i swagger.json -g python -o ./sdk/python

# TypeScript
npx openapi-generator-cli generate -i swagger.json -g typescript-fetch -o ./sdk/ts
```

---

## 📞 Suporte

- **Email**: api-support@tudoaqui.ao
- **Docs**: https://docs.tudoaqui.ao
- **Status**: https://status.tudoaqui.ao
- **Swagger UI**: http://localhost:3000/api-docs

---

## 📋 Changelog API

### v1.0.0 (2026-01-22)
- ✅ Lançamento inicial
- ✅ Endpoints de autenticação com JWT
- ✅ Endpoints de imóveis
- ✅ Endpoints de transporte (multi-provider)
- ✅ Endpoints de turismo
- ✅ Endpoints de eventos
- ✅ Endpoints de ingressos com QR code
- ✅ Endpoints de restaurantes
- ✅ Endpoints de alojamentos
- ✅ Endpoints de pagamentos (4 métodos)
- ✅ Endpoints de observabilidade (Prometheus)
- ✅ Documentação completa OpenAPI 3.0

---

**Última atualização**: 22 de Janeiro de 2026
