# TudoAqui - Manual de Usuário

**Versão**: 1.0.0  
**Data**: Janeiro de 2026  
**Lema**: "Encontre tudo num só lugar"

---

## 📑 Índice

1. [Introdução](#introdução)
2. [Cadastro e Login](#cadastro-e-login)
3. [Imóveis](#imóveis)
4. [Transporte](#transporte)
5. [Turismo](#turismo)
6. [Eventos](#eventos)
7. [Ingressos](#ingressos)
8. [Restaurantes](#restaurantes)
9. [Alojamentos](#alojamentos)
10. [Pagamentos](#pagamentos)
11. [Notificações](#notificações)
12. [Perfil e Configurações](#perfil-e-configurações)
13. [Segurança](#segurança)
14. [Suporte](#suporte)

---

## 🌟 Introdução

### O que é o TudoAqui?

O **TudoAqui** é o primeiro super app de Angola que reúne todos os serviços essenciais em uma única plataforma. Com ele, você pode:

- 🏠 **Comprar, alugar ou anunciar imóveis**
- 🚗 **Chamar táxi** de vários fornecedores
- 🌴 **Reservar pacotes turísticos**
- 🎉 **Alugar salas para eventos**
- 🎫 **Comprar ingressos** para shows e teatros
- 🍽️ **Reservar mesas** ou pedir delivery
- 🏨 **Reservar hotéis e alojamentos**
- 💳 **Pagar com segurança** via Multicaixa, cartão ou transferência

### Por que usar o TudoAqui?

✅ **Tudo em um só lugar** - Um app para todas as suas necessidades  
✅ **Segurança garantida** - KYC com verificação de BI  
✅ **Selo de Verificado** - Vendedores confiáveis  
✅ **Pagamentos seguros** - Múltiplos métodos de pagamento  
✅ **Suporte local** - Feito para Angola, por angolanos

---

## 🔐 Cadastro e Login

### Como se cadastrar

#### Passo 1: Baixar o App
- Baixe na **Google Play Store** (Android)
- Baixe na **App Store** (iOS)
- Ou acesse pelo navegador: `https://app.tudoaqui.ao`

#### Passo 2: Criar Conta
1. Abra o app TudoAqui
2. Toque em **"Criar conta"**
3. Preencha seus dados:
   - **Nome completo**
   - **Email**
   - **Telefone** (formato: 923456789)
   - **Senha** (mínimo 8 caracteres, com maiúscula, minúscula e número)
4. Escolha o tipo de conta:
   - **Comprador** - Para usar os serviços
   - **Vendedor** - Para publicar anúncios (requer verificação KYC)
   - **Prestador de Serviço** - Para oferecer serviços
5. Toque em **"Registrar"**

#### Passo 3: Verificar Telefone
1. Você receberá um SMS com código de 6 dígitos
2. Digite o código no app
3. Toque em **"Verificar"**

#### Passo 4: Verificação KYC (apenas para Vendedores)
Se você escolheu conta de **Vendedor**, precisará verificar sua identidade:

1. Vá para **"Perfil" > "Verificar Identidade"**
2. Tire foto do **Bilhete de Identidade** (frente)
3. Tire uma **selfie** (para liveness detection)
4. Se for empresa, envie **Alvará** ou **Diário da República**
5. Aguarde análise (24-48 horas)
6. Receba notificação quando aprovado
7. Ganhe o **Selo de Verificado** ✅

### Como fazer login

1. Abra o app TudoAqui
2. Digite seu **email** e **senha**
3. Toque em **"Entrar"**

**Dica**: Active biometria (impressão digital ou Face ID) para login rápido.

### Esqueci minha senha

1. Na tela de login, toque em **"Esqueci a senha"**
2. Digite seu email
3. Verifique seu email para link de redefinição
4. Crie nova senha
5. Faça login

---

## 🏠 Imóveis

### Como buscar imóveis

#### Busca Simples
1. Abra o app e vá para **"Imóveis"**
2. Use a barra de pesquisa para digitar localização
3. Veja os resultados em **lista** ou **mapa**

#### Busca com Filtros
1. Toque no ícone de **filtro** (⚙️)
2. Configure os filtros:
   - **Tipo**: Casa, Apartamento, Terreno, Escritório
   - **Finalidade**: Venda, Aluguel, Temporada
   - **Preço**: Mínimo e máximo (em AOA)
   - **Localização**: Província, Município, Bairro
   - **Quartos**: Número de quartos
   - **Banheiros**: Número de banheiros
   - **Área**: Área mínima e máxima (m²)
3. Toque em **"Aplicar filtros"**
4. Veja os resultados ordenados por:
   - Preço (crescente/decrescente)
   - Data de publicação
   - Avaliação

#### Ver Detalhes do Imóvel
1. Toque no imóvel desejado
2. Veja:
   - **Fotos** (galeria com zoom)
   - **Descrição completa**
   - **Preço e condições**
   - **Localização no mapa**
   - **Informações do vendedor**
   - **Imóveis similares**
3. Use as opções:
   - 💬 **Chat** - Conversar com vendedor (sem expor seu número)
   - 📞 **Ligar** - Revelar número de telefone
   - ❤️ **Favoritar** - Salvar para ver depois
   - 📤 **Compartilhar** - Enviar link para amigos

### Como publicar um imóvel

**Requisito**: Conta verificada com **Selo de Verificado** ✅

#### Passo 1: Iniciar Publicação
1. Vá para **"Imóveis"**
2. Toque no botão **"+"** ou **"Publicar"**
3. Escolha o tipo de anúncio

#### Passo 2: Informações Básicas
Preencha:
- **Título** (ex: "Casa 3 quartos em Talatona")
- **Descrição** detalhada
- **Tipo**: Casa, Apartamento, Terreno, Escritório
- **Finalidade**: Venda, Aluguel, Temporada
- **Preço** (em AOA)

#### Passo 3: Características
Informe:
- **Quartos**: Número de quartos
- **Banheiros**: Número de banheiros
- **Área total**: Em metros quadrados (m²)
- **Garagem**: Vagas disponíveis
- **Comodidades**: Piscina, churrasqueira, segurança, etc.

#### Passo 4: Localização
1. Digite o endereço completo
2. Ou use **"Usar minha localização"**
3. Ajuste o pino no mapa se necessário
4. Confirme Província, Município e Bairro

#### Passo 5: Fotos
1. Toque em **"Adicionar fotos"**
2. Escolha até **20 fotos**
3. **Dica**: Primeira foto é a capa - escolha a melhor!
4. Todas as fotos recebem **marca d'água "TudoAqui"** automaticamente

#### Passo 6: Revisar e Publicar
1. Revise todas as informações
2. Toque em **"Publicar anúncio"**
3. Anúncio entra no ar imediatamente!
4. Compartilhe link nas redes sociais

### Gerenciar meus imóveis

1. Vá para **"Perfil" > "Meus Imóveis"**
2. Veja todos os seus anúncios
3. Opções disponíveis:
   - 📊 **Estatísticas** - Visualizações, contatos, favoritos
   - ✏️ **Editar** - Atualizar informações
   - 🚫 **Pausar** - Desativar temporariamente
   - 🗑️ **Excluir** - Remover anúncio

---

## 🚗 Transporte

### Como chamar um táxi

#### Passo 1: Definir Localização
1. Vá para **"Transporte"**
2. O app detecta sua localização automaticamente
3. Ou digite o endereço de origem

#### Passo 2: Escolher Destino
1. Digite o endereço de destino
2. Ou selecione no mapa
3. Confirme a rota

#### Passo 3: Comparar Fornecedores
O TudoAqui busca preços em **4 fornecedores**:
- 🚖 **Tupuca**
- 🚕 **Yango**
- 🚗 **Bolt**
- 🚙 **Heetch**

Compare:
- **Preço** (em AOA)
- **Tempo estimado** (em minutos)
- **Motoristas disponíveis**
- **Avaliação**

#### Passo 4: Confirmar Viagem
1. Escolha o fornecedor desejado
2. Toque em **"Confirmar"**
3. Aguarde motorista aceitar (geralmente 1-3 minutos)

#### Passo 5: Acompanhar Corrida
1. Veja localização do motorista em tempo real
2. Receba notificação quando motorista chegar
3. Informações do veículo (placa, modelo, cor)
4. Informações do motorista (nome, foto, avaliação)

#### Passo 6: Finalizar
1. Ao chegar, pague diretamente ao motorista
2. Ou use pagamento integrado no app (se disponível)
3. Avalie sua experiência (1-5 estrelas)

---

## 🌴 Turismo

### Como explorar pacotes turísticos

1. Vá para **"Turismo"**
2. Navegue pelas categorias:
   - **Praias** - Ilha de Mussulo, Cabo Ledo, Barra do Kwanza
   - **Serra** - Lubango, Tundavala, Cristo Rei
   - **Safári** - Parques nacionais, observação de animais
   - **Cultura** - Museus, centros históricos, artesanato
   - **Aventura** - Rapel, trilhas, canoagem
3. Use filtros:
   - **Destino**
   - **Preço**
   - **Duração** (1 dia, fim de semana, semana)
   - **Tipo de experiência**

### Como reservar um pacote

#### Passo 1: Escolher Pacote
1. Toque no pacote desejado
2. Veja detalhes:
   - **Itinerário completo**
   - **O que está incluído** (transporte, alimentação, guia)
   - **O que NÃO está incluído**
   - **Política de cancelamento**
   - **Fotos e vídeos**
   - **Avaliações de outros clientes**

#### Passo 2: Configurar Reserva
1. Selecione **data de início**
2. Informe **número de pessoas**
3. Escolha **tipo de quarto** (se aplicável):
   - Individual
   - Duplo
   - Triplo
   - Família
4. Veja **preço total calculado**

#### Passo 3: Informações do Viajante
1. Preencha dados dos viajantes:
   - Nome completo
   - BI ou passaporte
   - Data de nascimento
   - Telefone de emergência
2. Necessidades especiais (dieta, mobilidade, etc.)

#### Passo 4: Pagamento
1. Escolha método de pagamento
2. Confirme reserva
3. Receba **voucher** por email e no app

#### Passo 5: Dia da Viagem
1. Chegue no ponto de encontro 15 minutos antes
2. Apresente voucher (QR code no app)
3. Aproveite sua experiência!

### Minhas reservas de turismo

1. Vá para **"Turismo" > "Minhas Reservas"**
2. Veja reservas:
   - **Próximas** - Reservas confirmadas
   - **Concluídas** - Viagens já realizadas
   - **Canceladas**
3. Opções:
   - 📄 **Ver detalhes**
   - 📲 **Mostrar voucher**
   - 📞 **Contatar operadora**
   - ❌ **Cancelar** (sujeito a política de cancelamento)

---

## 🎉 Eventos

### Como encontrar salas para eventos

#### Passo 1: Buscar Salas
1. Vá para **"Eventos"**
2. Use filtros:
   - **Localização** (província, município)
   - **Capacidade** (número de pessoas)
   - **Data do evento**
   - **Tipo de evento**: Casamento, Aniversário, Corporativo, Formatura, etc.
   - **Comodidades**: Ar condicionado, estacionamento, cozinha, decoração

#### Passo 2: Ver Detalhes
Cada sala mostra:
- **Fotos** (interior, exterior, eventos realizados)
- **Capacidade máxima**
- **Dimensões** (m²)
- **Comodidades incluídas**
- **Serviços extras** (catering, decoração, som)
- **Preço por hora/dia**
- **Calendário de disponibilidade**
- **Avaliações**

### Como reservar uma sala

#### Passo 1: Verificar Disponibilidade
1. Escolha a sala desejada
2. Selecione **data do evento**
3. Informe **horário** (início e fim)
4. Sistema verifica disponibilidade em tempo real

#### Passo 2: Configurar Evento
Preencha:
- **Tipo de evento**
- **Número estimado de convidados**
- **Serviços extras desejados**:
  - 🍽️ Buffet/Catering
  - 🎈 Decoração
  - 🔊 Som e iluminação
  - 📹 Fotografia/Vídeo
  - 🚗 Valet parking

#### Passo 3: Orçamento
1. Veja **orçamento detalhado**:
   - Aluguel da sala
   - Serviços extras
   - Taxas
   - **Total**
2. Solicite alterações se necessário

#### Passo 4: Confirmar Reserva
1. Leia os **Termos de Uso**
2. Política de cancelamento
3. Faça pagamento (sinal de 30% comum)
4. Receba **contrato digital**

#### Passo 5: Gerenciar Reserva
1. Veja em **"Eventos" > "Minhas Reservas"**
2. Entre em contato com responsável
3. Agende visita à sala
4. Finalize detalhes até 7 dias antes

---

## 🎫 Ingressos

### Como comprar ingressos

#### Passo 1: Encontrar Eventos
1. Vá para **"Ingressos"**
2. Categorias disponíveis:
   - 🎤 **Shows** - Música ao vivo, festivais
   - 🎭 **Teatro** - Peças, stand-up comedy
   - ⚽ **Esportes** - Futebol, basquete, outros
   - 🎬 **Cinema** - Pré-estreias, eventos especiais
   - 🎨 **Cultura** - Exposições, workshops
3. Use filtros:
   - **Data**
   - **Localização**
   - **Faixa de preço**
   - **Categoria**

#### Passo 2: Ver Detalhes do Evento
Informações disponíveis:
- **Data e horário**
- **Local** (com mapa)
- **Artista/Time/Peça**
- **Classificação etária**
- **Duração**
- **Mapa de setores** (se aplicável)
- **Fotos e vídeos promocionais**

#### Passo 3: Escolher Ingressos
1. Selecione **setor** (pista, cadeira, camarote)
2. Escolha **quantidade** (máximo 6 por compra)
3. Veja **preços**:
   - Inteira
   - Meia-entrada (estudante, idoso)
   - Cortesia (se aplicável)
4. Veja taxa de serviço
5. **Total calculado**

#### Passo 4: Dados do Comprador
1. Confirme seus dados
2. Se meia-entrada, prepare documento comprovante
3. Informe email para envio

#### Passo 5: Pagamento
1. Escolha método de pagamento
2. Finalize compra
3. Receba confirmação por **email** e **push notification**

#### Passo 6: Receber Ingressos
1. Ingressos aparecem em **"Ingressos" > "Meus Ingressos"**
2. Cada ingresso tem **QR code único**
3. Baixe PDF para imprimir (opcional)
4. Compartilhe com amigos (transferência de ingresso)

### No dia do evento

1. Abra o app TudoAqui
2. Vá para **"Meus Ingressos"**
3. Mostre **QR code** na entrada
4. Organizador escaneia e valida
5. Ingresso é marcado como **"Usado"** (não pode reutilizar)

**Dica**: Baixe ingressos offline antes do evento para evitar problemas de conexão.

### Política de Cancelamento

- ⚠️ **Ingressos não são reembolsáveis** após compra
- ⚠️ Eventos podem ser cancelados pelo organizador (reembolso total)
- Possível **transferir ingresso** para outra pessoa pelo app

---

## 🍽️ Restaurantes

### Como encontrar restaurantes

#### Passo 1: Navegar
1. Vá para **"Restaurantes"**
2. Veja restaurantes próximos (usa GPS)
3. Ou busque por localização específica

#### Passo 2: Filtrar
Use filtros:
- **Tipo de cozinha**: Angolana, Portuguesa, Italiana, Japonesa, Fast Food, etc.
- **Faixa de preço**: $, $$, $$$, $$$$
- **Avaliação**: Mínimo de estrelas
- **Características**:
  - Aceita reserva
  - Delivery disponível
  - Música ao vivo
  - Estacionamento
  - Pet-friendly
  - Vegetariano/Vegano

#### Passo 3: Ver Detalhes
Cada restaurante mostra:
- **Fotos** (ambiente, pratos)
- **Cardápio completo** com preços
- **Horário de funcionamento**
- **Localização e mapa**
- **Telefone**
- **Avaliações** e comentários
- **Pratos mais pedidos**

### Como reservar mesa

#### Método 1: Reserva Simples
1. Escolha o restaurante
2. Toque em **"Reservar Mesa"**
3. Selecione:
   - **Data**
   - **Horário** (almoço/jantar)
   - **Número de pessoas** (2-20)
4. Informe **nome** e **telefone**
5. Confirme reserva
6. Receba **confirmação** por SMS e no app

#### Método 2: Reserva com Pedido Antecipado
1. Faça reserva como acima
2. Escolha pratos do cardápio
3. Toque em **"Pedir para mesa"**
4. Comida fica pronta quando você chegar!

### Como pedir delivery

#### Passo 1: Escolher Restaurante
1. Vá para **"Restaurantes"**
2. Filtre por **"Delivery disponível"**
3. Veja **taxa de entrega** e **tempo estimado**

#### Passo 2: Montar Pedido
1. Navegue pelo cardápio
2. Toque nos pratos desejados
3. Customize (tamanho, ingredientes, observações)
4. Adicione ao carrinho
5. Veja **resumo do pedido**

#### Passo 3: Endereço de Entrega
1. Confirme endereço salvo
2. Ou adicione novo endereço:
   - Rua, número, bairro
   - Ponto de referência
   - Complemento (andar, apartamento)
3. Informe telefone para contato

#### Passo 4: Pagamento
Escolha método:
- 💳 **Cartão** (pague no app)
- 💵 **Dinheiro** (pague na entrega - informe se precisa troco)
- 📱 **Multicaixa** (pagamento instantâneo)

#### Passo 5: Acompanhar Pedido
1. Receba **confirmação** do restaurante
2. Status em tempo real:
   - 👨‍🍳 **Preparando**
   - 📦 **Saiu para entrega**
   - 🚴 **A caminho**
   - ✅ **Entregue**
3. Veja localização do entregador no mapa
4. Tempo estimado atualizado

#### Passo 6: Receber e Avaliar
1. Receba seu pedido
2. Confira itens
3. Avalie experiência (comida, embalagem, entregador)

---

## 🏨 Alojamentos

### Como buscar acomodações

#### Passo 1: Definir Busca
1. Vá para **"Alojamentos"**
2. Informe:
   - **Destino** (cidade, bairro)
   - **Data check-in**
   - **Data check-out**
   - **Número de hóspedes**
   - **Número de quartos**

#### Passo 2: Filtrar Resultados
Use filtros:
- **Tipo de acomodação**:
  - Hotel
  - Pousada
  - Apart-hotel
  - Casa/Apartamento completo
- **Preço por noite**
- **Avaliação** (mínimo de estrelas)
- **Comodidades**:
  - Wi-Fi gratuito
  - Estacionamento
  - Piscina
  - Academia
  - Restaurante
  - Café da manhã incluído
  - Ar condicionado
  - Pet-friendly

#### Passo 3: Ver Detalhes
Cada alojamento mostra:
- **Fotos** (quartos, áreas comuns, vistas)
- **Descrição** completa
- **Tipos de quarto** disponíveis
- **Preços** (por noite e total)
- **Políticas**:
  - Check-in/check-out
  - Cancelamento
  - Crianças
  - Pets
- **Avaliações** detalhadas
- **Localização no mapa**
- **Pontos de interesse próximos**

### Como reservar

#### Passo 1: Escolher Quarto
1. Selecione **tipo de quarto**:
   - Individual
   - Duplo
   - Triplo
   - Suíte
   - Apartamento
2. Veja o que está incluído
3. Confirme datas e número de hóspedes

#### Passo 2: Informações dos Hóspedes
Preencha dados:
- **Nome completo** do titular
- **Email** e **telefone**
- **BI ou Passaporte**
- **Horário aproximado de chegada**
- **Solicitações especiais** (berço, andar alto, etc.)

#### Passo 3: Calcular Total
Veja breakdown:
- Diárias (valor × número de noites)
- Taxas de serviço
- Taxa de turismo (se aplicável)
- **Total**

#### Passo 4: Pagamento
Opções:
- **Pagamento total** no app (mais seguro)
- **Pagamento na chegada** (se hotel aceitar)
- **Pagamento parcial** (sinal de 30-50%)

#### Passo 5: Confirmação
1. Receba **voucher de reserva**
2. Email com detalhes:
   - Endereço do hotel
   - Mapa
   - Telefone
   - Política de cancelamento
   - Código de reserva

### No dia do check-in

1. Chegue no horário informado (geralmente após 14h)
2. Apresente:
   - **Voucher** (no app ou impresso)
   - **BI ou Passaporte**
3. Faça check-in
4. Receba chave do quarto

### Cancelamento

1. Vá para **"Alojamentos" > "Minhas Reservas"**
2. Selecione a reserva
3. Toque em **"Cancelar reserva"**
4. Leia **política de cancelamento**:
   - **Reembolso total**: Geralmente até 7 dias antes
   - **Reembolso parcial**: 3-7 dias antes
   - **Sem reembolso**: Menos de 3 dias ou no-show
5. Confirme cancelamento
6. Reembolso processado em 5-10 dias úteis

---

## 💳 Pagamentos

### Métodos disponíveis

O TudoAqui oferece **4 métodos de pagamento**:

#### 1. 📱 Multicaixa Express
- Pagamento via ATM ou app Multicaixa
- **Mais usado em Angola**
- Instantâneo e seguro
- **Valor mínimo**: 100 AOA

**Como usar**:
1. Escolha **"Multicaixa"** no checkout
2. Receba **referência de pagamento**
3. Vá ao ATM ou app Multicaixa
4. Digite a referência
5. Confirme pagamento
6. TudoAqui atualiza status automaticamente

#### 2. 💳 Cartão de Crédito
- Visa, Mastercard, American Express
- Processado via **Stripe** (segurança internacional)
- Parcelamento disponível (em breve)
- **Valor mínimo**: 100 AOA

**Como usar**:
1. Escolha **"Cartão de Crédito"**
2. Digite dados do cartão:
   - Número
   - Nome no cartão
   - Validade
   - CVV
3. Salve cartão para próximas compras (opcional)
4. Confirme pagamento
5. Aprovação instantânea

#### 3. 🏦 Transferência Bancária
- Para valores altos
- Bancos aceitos: BAI, BFA, BIC, Atlântico, etc.
- Confirmação em 1-2 dias úteis
- **Valor mínimo**: 100 AOA

**Como usar**:
1. Escolha **"Transferência Bancária"**
2. Receba **dados bancários** do TudoAqui:
   - Banco
   - NIB
   - IBAN
   - Referência (informar no comprovativo)
3. Faça transferência no seu banco
4. Upload **comprovativo** no app
5. Aguarde confirmação (24-48h)

#### 4. 💵 Dinheiro
- Apenas para **delivery** e **serviços presenciais**
- Pagamento na entrega
- **Valor mínimo**: 100 AOA

**Como usar**:
1. Escolha **"Dinheiro"** no checkout
2. Informe se precisa **troco** (e valor da nota)
3. Pague ao entregador
4. Solicite recibo

### Comprovativo de Pagamento

Após confirmação, você recebe:
- 📧 **Email** com comprovativo
- 📄 **PDF** disponível no app
- 📲 **Notificação push**
- Comprovativo mostra:
  - Número da transação
  - Data e hora
  - Método de pagamento
  - Valor pago
  - Descrição do item/serviço
  - Status

### Histórico de Transações

1. Vá para **"Perfil" > "Meus Pagamentos"**
2. Veja todas as transações:
   - ✅ **Confirmadas**
   - ⏳ **Pendentes**
   - ❌ **Canceladas**
3. Filtre por:
   - Período (última semana, mês, ano)
   - Método de pagamento
   - Módulo (imóveis, transporte, etc.)
4. Opções:
   - 📄 **Ver detalhes**
   - 💾 **Baixar comprovativo**
   - 📤 **Compartilhar**
   - ❌ **Solicitar reembolso** (se elegível)

### Segurança de Pagamentos

🔒 **Seus dados estão protegidos**:
- Criptografia **SSL/TLS** em todas as transações
- Dados de cartão **não são armazenados** no TudoAqui
- Tokenização via Stripe (PCI DSS Level 1)
- Autenticação 3D Secure (quando disponível)
- Monitoramento anti-fraude 24/7

---

## 🔔 Notificações

### Tipos de notificações

O TudoAqui envia notificações via:

#### 1. 📲 Push (no app)
- Atualizações em tempo real
- Toque para ver detalhes

#### 2. 📧 Email
- Confirmações importantes
- Recibos e vouchers
- Newsletter (opcional)

#### 3. 💬 SMS
- Código de verificação
- Alertas críticos (cancelamento de evento, etc.)

### Notificações que você recebe

#### Transações
- ✅ Pagamento confirmado
- ⏳ Pagamento pendente
- ❌ Pagamento recusado
- 💰 Reembolso processado

#### Reservas
- 📅 Reserva confirmada
- ⏰ Lembrete 24h antes
- ✅ Check-in realizado
- ⭐ Avalie sua experiência

#### Mensagens
- 💬 Nova mensagem de vendedor
- 💬 Resposta do suporte

#### Atualizações
- 🚗 Motorista a caminho
- 📦 Pedido saiu para entrega
- ✅ Pedido entregue

#### Promoções (se ativado)
- 🎉 Ofertas especiais
- 💰 Descontos exclusivos
- 🆕 Novos serviços

### Gerenciar notificações

1. Vá para **"Perfil" > "Configurações" > "Notificações"**
2. Ative/desative por tipo:
   - Push notifications
   - Email
   - SMS
3. Escolha o que receber:
   - Transações (recomendado manter ativo)
   - Reservas (recomendado)
   - Mensagens (recomendado)
   - Promoções (opcional)
   - Newsletter (opcional)

---

## 👤 Perfil e Configurações

### Editar perfil

1. Vá para **"Perfil"**
2. Toque em **"Editar Perfil"**
3. Atualize:
   - 📷 **Foto de perfil**
   - 👤 **Nome**
   - 📧 **Email** (requer verificação)
   - 📱 **Telefone** (requer verificação SMS)
   - 📍 **Endereço principal**
   - 🎂 **Data de nascimento**
   - 👥 **Tipo de conta**

### Verificação de identidade

Para obter o **Selo de Verificado** ✅:

1. Vá para **"Perfil" > "Verificar Identidade"**
2. Siga as etapas da seção [Cadastro e Login](#cadastro-e-login)
3. Status da verificação:
   - ⏳ **Pendente** - Documentos em análise
   - ✅ **Aprovado** - Selo concedido
   - ❌ **Rejeitado** - Documentos não aceitos (motivo informado)

### Endereços salvos

1. Vá para **"Perfil" > "Meus Endereços"**
2. Adicione endereços:
   - 🏠 Casa
   - 💼 Trabalho
   - 📍 Outros
3. Use para:
   - Delivery
   - Definir localização em buscas
   - Rotas de transporte

### Métodos de pagamento salvos

1. Vá para **"Perfil" > "Métodos de Pagamento"**
2. Adicione:
   - 💳 Cartões de crédito (dados tokenizados)
   - 📱 Número Multicaixa
3. Defina método padrão
4. Remova métodos antigos

### Configurações de privacidade

1. Vá para **"Perfil" > "Privacidade"**
2. Configure:
   - **Perfil público** ou **privado**
   - **Mostrar telefone** em anúncios
   - **Histórico de atividade** visível
   - **Compartilhamento de localização**

### Idioma

1. Vá para **"Perfil" > "Configurações" > "Idioma"**
2. Escolha:
   - 🇦🇴 **Português (Angola)** - Padrão
   - 🇵🇹 Português (Portugal)
   - 🇬🇧 English

---

## 🔒 Segurança

### Proteção da sua conta

#### 1. Senha forte
- Mínimo **8 caracteres**
- Inclua **maiúsculas e minúsculas**
- Inclua **números**
- Inclua **caracteres especiais** (!, @, #, etc.)
- **Não compartilhe** sua senha

#### 2. Verificação em duas etapas (2FA)
1. Vá para **"Perfil" > "Segurança"**
2. Ative **"Verificação em 2 etapas"**
3. Escolha método:
   - 📲 **SMS** (código de 6 dígitos)
   - 📧 **Email**
4. A cada login, você receberá código adicional

#### 3. Biometria
- Active **impressão digital** ou **Face ID**
- Login mais rápido e seguro
- Disponível em **"Perfil" > "Segurança"**

#### 4. Sessões ativas
1. Vá para **"Perfil" > "Segurança" > "Sessões"**
2. Veja todos os dispositivos logados
3. **Encerre sessões** suspeitas remotamente

### Denunciar fraude

Se você encontrar:
- 🚫 Anúncio suspeito ou fraudulento
- 🚫 Perfil falso
- 🚫 Comportamento inadequado

**Ação imediata**:
1. Toque nos **3 pontos** (⋮) no anúncio/perfil
2. Escolha **"Denunciar"**
3. Selecione motivo:
   - Fraude
   - Conteúdo inapropriado
   - Spam
   - Preço abusivo
   - Informação falsa
4. Adicione detalhes
5. Envie denúncia
6. Nossa equipe analisa em **24-48 horas**

### Selo de Verificado

O **Selo de Verificado** ✅ garante que:
- Vendedor enviou **BI válido**
- **Reconhecimento facial** aprovado
- Empresas enviaram **Alvará**
- Análise manual aprovada pela equipe TudoAqui

**Sempre prefira negociar com usuários verificados!**

### Dicas de segurança

✅ **Faça**:
- Use pagamento pelo app (mais seguro)
- Verifique Selo de Verificado
- Leia avaliações antes de comprar
- Encontre vendedor em local público (se presencial)
- Inspecione produto antes de pagar (se presencial)
- Solicite comprovativo/recibo

❌ **Não faça**:
- Não pague fora do app (sem proteção)
- Não compartilhe senha
- Não aceite propostas "boas demais para ser verdade"
- Não encontre vendedor em local isolado
- Não faça depósito sem garantia

---

## 📞 Suporte

### Canais de atendimento

#### 1. 💬 Chat no App
- Atendimento **24/7** (bot + humano)
- Resposta em minutos
- **Como acessar**:
  1. Toque no ícone **💬** no menu principal
  2. Ou vá para **"Perfil" > "Ajuda" > "Chat"**
  3. Descreva seu problema
  4. Receba assistência imediata

#### 2. 📧 Email
- **suporte@tudoaqui.ao**
- Resposta em até **24 horas** (dias úteis)
- Use para:
  - Problemas técnicos complexos
  - Solicitações de reembolso
  - Denúncias detalhadas
  - Feedback e sugestões

#### 3. 📱 WhatsApp
- **+244 923 123 456**
- Horário: **Segunda a Sexta, 8h-18h**
- Sábado: **9h-13h**
- Use para:
  - Dúvidas rápidas
  - Suporte prioritário
  - Emergências

#### 4. 📞 Telefone
- **+244 222 123 456** (Luanda)
- **Custo de ligação local**
- Horário: **Segunda a Sexta, 8h-18h**

#### 5. 🏢 Atendimento Presencial
**Escritório TudoAqui - Luanda**
- Endereço: Rua Comandante Che Guevara, Edifício Atlântico, Piso 5
- Horário: **Segunda a Sexta, 9h-17h**
- **Agende visita**: suporte@tudoaqui.ao

### Central de Ajuda (FAQ)

Acesse **"Perfil" > "Ajuda" > "Central de Ajuda"**

Categorias:
- 🏠 **Imóveis** - Publicar, buscar, contatar vendedor
- 🚗 **Transporte** - Chamar táxi, rastreamento
- 💳 **Pagamentos** - Métodos, reembolso, comprovativo
- 👤 **Conta** - Cadastro, verificação, edição
- 🔒 **Segurança** - Senha, 2FA, denúncias
- 📦 **Pedidos** - Rastreamento, cancelamento

### Solicitar reembolso

**Elegibilidade**:
- ✅ Evento cancelado pelo organizador
- ✅ Serviço não prestado
- ✅ Produto não entregue
- ✅ Cancelamento dentro da política
- ❌ Desistência após prazo
- ❌ Mudança de ideia (não elegível)

**Como solicitar**:
1. Vá para **"Meus Pagamentos"**
2. Selecione a transação
3. Toque em **"Solicitar Reembolso"**
4. Informe motivo
5. Anexe comprovantes (se aplicável)
6. Envie solicitação
7. Análise em **3-5 dias úteis**
8. Reembolso processado em **10 dias úteis** se aprovado

### Avaliações e Feedback

Ajude a melhorar o TudoAqui:

#### Avaliar vendedor/serviço
1. Após concluir transação, você recebe notificação
2. Toque em **"Avaliar"**
3. Dê estrelas (1-5)
4. Escreva comentário (opcional)
5. Seja justo e honesto

#### Sugerir melhoria
1. Vá para **"Perfil" > "Ajuda" > "Enviar Feedback"**
2. Escolha tipo:
   - 🐛 Reportar bug
   - 💡 Sugerir funcionalidade
   - ❤️ Elogio
   - 😞 Reclamação
3. Descreva detalhadamente
4. Anexe prints (se aplicável)
5. Envie

### Termos de Uso e Privacidade

- 📄 **Termos de Uso**: https://tudoaqui.ao/termos
- 🔒 **Política de Privacidade**: https://tudoaqui.ao/privacidade
- 🍪 **Política de Cookies**: https://tudoaqui.ao/cookies

---

## 📱 Redes Sociais

Siga o TudoAqui:

- 📘 **Facebook**: @TudoAquiAO
- 📸 **Instagram**: @tudoaqui
- 🐦 **Twitter**: @TudoAquiAO
- 💼 **LinkedIn**: TudoAqui Angola
- 🎥 **YouTube**: TudoAqui Angola

Fique por dentro de:
- 🎉 Promoções exclusivas
- 🆕 Novos serviços
- 💡 Dicas e tutoriais
- 📣 Anúncios importantes

---

## ❓ Perguntas Frequentes

### Sobre a conta

**P: O cadastro é gratuito?**  
R: Sim, 100% gratuito para sempre.

**P: Posso ter mais de uma conta?**  
R: Não, cada pessoa/empresa deve ter apenas uma conta. Múltiplas contas podem ser banidas.

**P: Quanto tempo leva a verificação KYC?**  
R: Geralmente 24-48 horas. Em casos complexos, até 5 dias úteis.

**P: Posso mudar de conta Comprador para Vendedor?**  
R: Sim! Vá em "Perfil" > "Tipo de Conta" e solicite alteração. Precisará fazer verificação KYC.

### Sobre pagamentos

**P: Quais taxas o TudoAqui cobra?**  
R: 
- Compradores: **0% de taxa** na maioria dos serviços
- Vendedores: Comissão variável por venda (5-15% conforme categoria)
- Ingressos: Taxa de serviço de 5-10%

**P: Quando recebo o reembolso?**  
R: Após aprovação, o reembolso é processado em 5-10 dias úteis, dependendo do método de pagamento original.

**P: Meu pagamento foi recusado. O que fazer?**  
R: Verifique saldo, limite do cartão ou tente outro método. Se persistir, contate suporte.

### Sobre segurança

**P: Meus dados bancários estão seguros?**  
R: Sim. Usamos criptografia SSL/TLS e não armazenamos dados sensíveis. Cartões são tokenizados via Stripe.

**P: E se eu for vítima de fraude?**  
R: Denuncie imediatamente. Investigamos e tomamos ações (ban de usuário, reembolso se elegível).

**P: O que é o Selo de Verificado?**  
R: Indica que o vendedor passou por verificação KYC (BI + reconhecimento facial + Alvará se empresa).

### Sobre entregas/serviços

**P: Quanto tempo leva uma entrega?**  
R: Varia conforme restaurante/loja. Geralmente 30-60 minutos. Acompanhe em tempo real no app.

**P: Posso cancelar após confirmar?**  
R: Depende da política de cancelamento de cada serviço. Geralmente:
- Delivery: Até preparação começar
- Transporte: Até motorista aceitar
- Eventos/Ingressos: Conforme política do organizador

**P: E se o produto vier errado/danificado?**  
R: Contate suporte imediatamente via chat. Tire fotos. Solicitaremos reembolso ou troca.

---

## 🎉 Bem-vindo ao TudoAqui!

Agora que você conhece todas as funcionalidades, aproveite ao máximo o super app de Angola!

**Lembre-se**:
- ✅ Sempre verifique o Selo de Verificado
- ✅ Use pagamento pelo app para maior segurança
- ✅ Leia avaliações antes de comprar
- ✅ Entre em contato com suporte se precisar

**Encontre tudo num só lugar. Encontre TudoAqui!** 🇦🇴

---

**Última atualização**: 22 de Janeiro de 2026  
**Versão do Manual**: 1.0.0  

📧 **Suporte**: suporte@tudoaqui.ao  
🌐 **Website**: https://tudoaqui.ao  
📱 **App**: Baixe na Play Store ou App Store
