# Postman Collection - TudoAqui API

## 📥 Importar Coleção

1. Abra o Postman
2. Clique em **Import**
3. Selecione o arquivo `TudoAqui.postman_collection.json`
4. A coleção será importada com todos os 40+ endpoints

## 🔧 Configuração

### Variáveis de Ambiente

Crie um environment no Postman com estas variáveis:

```
base_url: http://localhost:3000/api/v1
auth_token: (será preenchido automaticamente após login)
```

### Variáveis Globais (Auto-Configuradas)

Após executar requests específicos, estas variáveis serão automaticamente salvas:

- `user_id` - ID do usuário logado
- `imovel_id` - ID do último imóvel criado
- `viagem_id` - ID da última viagem solicitada
- `reserva_turismo_id` - ID da última reserva de turismo
- `reserva_sala_id` - ID da última reserva de sala
- `ingresso_id` - ID do último ingresso comprado
- `codigo_qr` - QR code do último ingresso
- `reserva_restaurante_id` - ID da última reserva de restaurante
- `pedido_id` - ID do último pedido de comida
- `reserva_alojamento_id` - ID da última reserva de alojamento
- `transacao_id` - ID da última transação de pagamento

## 🚀 Workflow de Testes

### 1. Autenticação
```
1. Execute "Auth > Register" para criar conta
   → auth_token salvo automaticamente
   → user_id salvo automaticamente

2. OU execute "Auth > Login" se já tem conta
   → auth_token salvo automaticamente
   → user_id salvo automaticamente

3. Execute "Auth > Get Profile" para verificar autenticação
```

### 2. Criar Imóvel
```
1. Execute "Imóveis > Criar Imóvel"
   → imovel_id salvo automaticamente

2. Execute "Imóveis > Obter Imóvel" usando {{imovel_id}}

3. Execute "Imóveis > Listar Imóveis" com filtros
```

### 3. Solicitar Transporte
```
1. Execute "Transporte > Solicitar Viagem"
   → viagem_id salvo automaticamente

2. Execute "Transporte > Confirmar Viagem" usando {{viagem_id}}

3. Execute "Transporte > Rastrear Viagem" usando {{viagem_id}}
```

### 4. Comprar Ingressos
```
1. Execute "Ingressos > Comprar Ingressos"
   → ingresso_id e codigo_qr salvos automaticamente

2. Execute "Ingressos > Validar Ingresso" usando {{codigo_qr}}
```

### 5. Processar Pagamento
```
1. Execute "Pagamentos > Processar Pagamento"
   → transacao_id salvo automaticamente

2. Execute "Pagamentos > Confirmar Pagamento" com upload de comprovativo

3. Execute "Pagamentos > Histórico de Transações"

4. Execute "Pagamentos > Obter Transação" usando {{transacao_id}}
```

## 📋 Estrutura da Coleção

### 🔐 Auth (5 requests)
- Register
- Login
- Get Profile
- Update Profile
- Logout

### 🏠 Imóveis (4 requests)
- Listar Imóveis
- Criar Imóvel
- Obter Imóvel
- Meus Imóveis

### 🚗 Transporte (3 requests)
- Solicitar Viagem
- Confirmar Viagem
- Rastrear Viagem

### 🌴 Turismo (3 requests)
- Listar Pacotes
- Reservar Pacote
- Minhas Reservas

### 🎉 Eventos (2 requests)
- Listar Salas
- Reservar Sala

### 🎫 Ingressos (2 requests)
- Comprar Ingressos
- Validar Ingresso

### 🍽️ Restaurantes (3 requests)
- Listar Restaurantes
- Reservar Mesa
- Fazer Pedido

### 🏨 Alojamentos (2 requests)
- Listar Alojamentos
- Reservar Alojamento

### 💳 Pagamentos (5 requests)
- Processar Pagamento
- Confirmar Pagamento
- Histórico de Transações
- Obter Transação
- Cancelar Transação

### 📊 Observabilidade (3 requests)
- Health Check (Quick)
- Health Check (Detailed)
- Prometheus Metrics

**Total: 32 requests organizados** 📦

## 🔄 Scripts de Teste Automáticos

A coleção inclui scripts que automaticamente:

1. **Salvam tokens**: Após register/login, `auth_token` é salvo no environment
2. **Salvam IDs**: Após criar recursos, IDs são salvos em variáveis globais
3. **Facilitam testes**: Você pode executar requests sequencialmente sem copiar/colar IDs

### Exemplo de Script (Register):
```javascript
if (pm.response.code === 201) {
    const response = pm.response.json();
    pm.environment.set('auth_token', response.token);
    pm.globals.set('user_id', response.user.id);
}
```

## 🎯 Testes End-to-End

Execute nesta ordem para testar fluxo completo:

1. **Auth > Register** → Cria conta
2. **Imóveis > Criar Imóvel** → Cria listagem
3. **Pagamentos > Processar Pagamento** → Inicia transação
4. **Pagamentos > Confirmar Pagamento** → Upload de comprovativo
5. **Pagamentos > Histórico de Transações** → Verifica histórico
6. **Auth > Logout** → Encerra sessão

## 📝 Notas Importantes

### Autenticação
- Bearer token é aplicado automaticamente após login
- Token válido por 7 dias (configurável no backend)
- Endpoints públicos não requerem autenticação:
  - `GET /imoveis`
  - `GET /turismo/pacotes`
  - `GET /restaurantes`
  - `GET /alojamentos`
  - `GET /eventos/salas`
  - `/health` e `/metrics`

### Rate Limiting
- Auth endpoints: 5 requests/15 minutos
- API endpoints: 100 requests/15 minutos
- Health/Metrics: Sem limite

### Métodos de Pagamento
Valores aceitos para `metodo_pagamento`:
- `multicaixa` - ATM Angola
- `cartao_credito` - Stripe
- `transferencia` - Banco
- `dinheiro` - Pagamento na entrega

Valor mínimo: **100 AOA**

### Módulos de Pagamento
Valores aceitos para `modulo`:
- `imoveis`
- `transporte`
- `turismo`
- `eventos`
- `ingressos`
- `restaurantes`
- `alojamentos`

## 🔍 Dicas de Uso

1. **Runner**: Use Collection Runner para executar todos os requests automaticamente
2. **Environment**: Crie environments separados para Dev/Staging/Production
3. **Pre-request Scripts**: Todos os scripts estão configurados para auto-salvar variáveis
4. **Tests**: Scripts de teste validam status codes e salvam dados automaticamente

## 📞 Suporte

- **Documentação completa**: `API_DOCUMENTATION.md`
- **Swagger UI**: `http://localhost:3000/api-docs`
- **OpenAPI Spec**: `swagger.json`

---

**Última atualização**: 22 de Janeiro de 2026
