@echo off
REM Script de Execução de Migrações - TudoAqui Backend (Windows)
REM Este script executa todas as migrações SQL em ordem sequencial

setlocal enabledelayedexpansion

REM Configurações
if not defined DB_HOST set DB_HOST=localhost
if not defined DB_PORT set DB_PORT=5432
if not defined DB_NAME set DB_NAME=tudo_aqui_db
if not defined DB_USER set DB_USER=tudo_aqui_admin
if not defined DB_PASSWORD set DB_PASSWORD=senha_forte_2024

REM Diretório de migrações
set MIGRATIONS_DIR=%~dp0migrations

echo ========================================
echo === TudoAqui - Executor de Migracoes ===
echo ========================================
echo.
echo Configuracoes:
echo   Host: %DB_HOST%
echo   Port: %DB_PORT%
echo   Database: %DB_NAME%
echo   User: %DB_USER%
echo.

REM Verificar se o diretório existe
if not exist "%MIGRATIONS_DIR%" (
    echo Erro: Diretorio de migracoes nao encontrado: %MIGRATIONS_DIR%
    exit /b 1
)

REM Contar migrações
set MIGRATION_COUNT=0
for %%f in ("%MIGRATIONS_DIR%\*.sql") do set /a MIGRATION_COUNT+=1

if %MIGRATION_COUNT% equ 0 (
    echo Erro: Nenhum arquivo de migracao encontrado em %MIGRATIONS_DIR%
    exit /b 1
)

echo Encontradas %MIGRATION_COUNT% migracoes
echo.

REM Executar migrações
set MIGRATION_NUM=0
set ERROR_COUNT=0

for /f "delims=" %%f in ('dir /b /o:n "%MIGRATIONS_DIR%\*.sql"') do (
    set /a MIGRATION_NUM+=1
    set MIGRATION_NAME=%%f
    
    echo [!MIGRATION_NUM!] Executando !MIGRATION_NAME! ... 
    
    set PGPASSWORD=%DB_PASSWORD%
    psql -h %DB_HOST% -p %DB_PORT% -d %DB_NAME% -U %DB_USER% -f "%MIGRATIONS_DIR%\%%f" > nul 2>&1
    
    if !errorlevel! equ 0 (
        echo           [OK]
    ) else (
        echo           [ERRO]
        set /a ERROR_COUNT+=1
        
        REM Executar novamente com output de erro
        echo   Detalhes do erro:
        set PGPASSWORD=%DB_PASSWORD%
        psql -h %DB_HOST% -p %DB_PORT% -d %DB_NAME% -U %DB_USER% -f "%MIGRATIONS_DIR%\%%f" 2>&1
    )
)

REM Limpar variável
set PGPASSWORD=

echo.
echo ========================================
echo === Resumo ===
echo ========================================
echo Total de migracoes: %MIGRATION_COUNT%
echo Sucesso: %ERROR_COUNT%

if %ERROR_COUNT% gtr 0 (
    echo Erros: %ERROR_COUNT%
    exit /b 1
) else (
    echo Todas as migracoes executadas com sucesso!
    exit /b 0
)
