const { Pool } = require('pg');
const redis = require('./redis');

// Configuração do pool PostgreSQL
const connectionString = process.env.DATABASE_URL || `postgresql://${process.env.DATABASE_USER || 'postgres'}:${process.env.DATABASE_PASSWORD || ''}@${process.env.DATABASE_HOST || 'localhost'}:${process.env.DATABASE_PORT || '5432'}/${process.env.DATABASE_NAME || 'tudo_aqui_db'}`;

const pool = new Pool({
  connectionString,
  max: parseInt(process.env.PG_MAX || '20', 10),
  idleTimeoutMillis: parseInt(process.env.PG_IDLE_TIMEOUT || '30000', 10),
  connectionTimeoutMillis: parseInt(process.env.PG_CONN_TIMEOUT || '5000', 10)
});

pool.on('error', (err) => console.error('Erro no pool PostgreSQL:', err.message));

module.exports = { pool, redis };
