const Redis = require('ioredis');

// Instância única de Redis para toda a aplicação
const redis = new Redis(process.env.REDIS_URL || {
  host: process.env.REDIS_HOST || '127.0.0.1',
  port: parseInt(process.env.REDIS_PORT || '6379', 10),
  db: parseInt(process.env.REDIS_DB || '0', 10),
  password: process.env.REDIS_PASSWORD || undefined
});

redis.on('connect', () => console.log('Redis conectado'));
redis.on('error', (err) => console.error('Erro Redis:', err.message));

module.exports = redis;
