const swaggerUi = require('swagger-ui-express');
const swaggerDocument = require('../swagger.json');

const swaggerSetup = (app) => {
  app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(swaggerDocument, {
    explorer: true,
    swaggerOptions: {
      url: '/swagger.json',
      displayOperationId: false,
      docExpansion: 'list',
      defaultModelsExpandDepth: 1,
      persistAuthorizationData: true
    }
  }));

  // Servir arquivo swagger.json bruto
  app.get('/swagger.json', (req, res) => {
    res.setHeader('Content-Type', 'application/json');
    res.send(swaggerDocument);
  });
};

module.exports = swaggerSetup;
