const express = require('express');
const router = express.Router();
const ImoveisController = require('./imoveis.controller');
const { autenticar } = require('../../middleware/auth.middleware');

// Listagem pública de imóveis com filtros
router.get('/', ImoveisController.listarImoveis.bind(ImoveisController));

// Meus imóveis (requer usuário autenticado)
router.get('/meus', autenticar, ImoveisController.meusImoveis.bind(ImoveisController));

// Criar imóvel (requer usuário autenticado)
router.post('/', autenticar, ImoveisController.criarImovel.bind(ImoveisController));

// Detalhe de imóvel
router.get('/:id', ImoveisController.buscarImovelPorId.bind(ImoveisController));

module.exports = router;
