const express = require('express');
const router = express.Router();
const PagamentosController = require('./pagamentos.controller');
const { autenticar } = require('../../middleware/auth.middleware');

// Processar pagamento (Multicaixa, cartão, transferência, dinheiro)
router.post('/processar', autenticar, PagamentosController.processarPagamento.bind(PagamentosController));

// Confirmar pagamento com comprovativo
router.post('/confirmar', autenticar, PagamentosController.confirmarPagamento.bind(PagamentosController));

// Histórico de transações do usuário
router.get('/historico', autenticar, PagamentosController.listarTransacoes.bind(PagamentosController));

// Buscar transação por ID (antes da rota dinâmica colocar rotas específicas)
router.get('/:id', autenticar, PagamentosController.buscarTransacaoPorId.bind(PagamentosController));

// Cancelar transação
router.delete('/:id', autenticar, PagamentosController.cancelarTransacao.bind(PagamentosController));

module.exports = router;
