const express = require('express');
const router = express.Router();
const { healthCheck, quickHealthCheck, register } = require('../middleware/monitoring.middleware');

/**
 * Rota de health check rápido (para load balancer)
 * GET /health
 */
router.get('/', quickHealthCheck);

/**
 * Rota de health check detalhado (para observabilidade)
 * GET /health/detailed
 */
router.get('/detailed', healthCheck);

/**
 * Rota de métricas Prometheus
 * GET /metrics
 */
router.get('/metrics', async (req, res) => {
  try {
    res.set('Content-Type', register.contentType);
    res.end(await register.metrics());
  } catch (error) {
    console.error('Erro ao gerar métricas Prometheus:', error);
    res.status(500).json({ error: 'Erro ao gerar métricas' });
  }
});

module.exports = router;
