const app = require('./app');

const PORT = process.env.PORT || 3000;

// Subir servidor HTTP
const server = app.listen(PORT, () => {
  console.log(`TudoAqui API rodando na porta ${PORT}`);
});

// Tratamento básico de erros não capturados
process.on('unhandledRejection', (err) => {
  console.error('Unhandled Rejection:', err);
  server.close(() => process.exit(1));
});

process.on('uncaughtException', (err) => {
  console.error('Uncaught Exception:', err);
  server.close(() => process.exit(1));
});

module.exports = server;
