const Joi = require('joi');

const imovelSchema = Joi.object({
  titulo: Joi.string().min(3).max(255).required(),
  descricao: Joi.string().max(5000).allow('', null),
  tipo: Joi.string().valid('casa', 'apartamento', 'terreno', 'escritorio').required(),
  finalidade: Joi.string().valid('venda', 'aluguel', 'temporada').required(),
  preco: Joi.number().positive().required(),
  localizacao: Joi.string().max(255).allow('', null),
  latitude: Joi.number().min(-90).max(90).allow(null),
  longitude: Joi.number().min(-180).max(180).allow(null),
  endereco_completo: Joi.object().unknown(true).default({}),
  quartos: Joi.number().integer().min(0).allow(null),
  banheiros: Joi.number().integer().min(0).allow(null),
  suites: Joi.number().integer().min(0).allow(null),
  area_total: Joi.number().positive().allow(null),
  vagas_garagem: Joi.number().integer().min(0).allow(null),
  comodidades: Joi.array().items(Joi.string().max(100)).default([]),
  fotos: Joi.array().items(Joi.string().uri()).default([])
});

const validateImovel = (data) => imovelSchema.validate(data, { abortEarly: false });

module.exports = {
  validateImovel
};
