# 🧪 Como Testar o Backend TudoAqui com Postman

## 📥 Passo 1: Importar Coleção no Postman

1. Abrir **Postman** Desktop ou Web
2. Clicar em **Import** (canto superior esquerdo)
3. Arrastar o ficheiro `TudoAqui-Postman-Collection.json` ou clicar **Choose Files**
4. Confirmar importação

## 🌍 Passo 2: Configurar Environment

1. Clicar no ícone **Environments** (⚙️ no canto superior direito)
2. Clicar em **Import** novamente
3. Selecionar `TudoAqui-Environment.json`
4. Ativar o environment "TudoAqui - Development" no dropdown superior direito

## ✅ Passo 3: Testar Endpoints em Sequência

### **Fluxo Recomendado para Teste Completo:**

#### 1️⃣ **Módulo Auth + KYC**
```
1. "Registar Vendedor" → Guarda automaticamente o JWT token
2. "Login" (opcional, usar o token do registo)
3. "Upload BI" → Adicionar foto do seu BI (caminho no corpo do request)
4. "Upload Selfie" → Adicionar selfie
5. "Status KYC" → Verificar estado da verificação
6. "Analisar com IA" → Processar com AWS Rekognition
```

**Nota:** Após "Registar Vendedor", o token JWT é automaticamente guardado na variável `{{jwt_token}}` do environment (script no Test tab faz isso).

---

#### 2️⃣ **Módulo Marketplace**
```
1. "Criar Anúncio - Imóvel" → Upload de 1-2 fotos (testa marca d'água)
   OU
   "Criar Anúncio - Veículo" → Upload de fotos de carro
   
2. "Listar Anúncios - Todos" → Ver todos os anúncios
3. "Listar Anúncios - Perto de Mim" → Testa PostGIS (raio de 5km)
4. "Listar Anúncios - Filtro por Província" → Filtra por Luanda
5. "Buscar Anúncios por Texto" → Busca "Kilamba mobilado"
6. "Obter Anúncio Específico" → Ver detalhes + contagem de visualizações
```

**Testar Marca d'água:**
- Após criar anúncio, verificar resposta JSON campo `fotos` (array com URLs)
- Navegar para pasta `backend/uploads/anuncios/marca-dagua/`
- Abrir imagem e confirmar "TudoAqui" no canto inferior direito

---

#### 3️⃣ **Módulo Logística (Tupuca)**
```
1. "Calcular Estimativa de Entrega" → Testa fórmula Haversine
   - Deve retornar: distanciaKm, tempoEstimadoMinutos, precoEntrega
   - Preço: 500 Kz base + 150 Kz/km
   
2. "Criar Pedido de Entrega" → Gera trackingId (TUPUCA-{timestamp})
   - trackingId guardado automaticamente no environment
   
3. "Rastrear Entrega" → Ver localização GPS (mock: Luanda -8.8383, 13.2344)
```

**Testar Pricing:**
- Distância de 2km → 500 + (2 × 150) = 800 Kz
- Tempo estimado → (2 × 5) + 10 = 20 minutos

---

#### 4️⃣ **Módulo Pagamentos (Multicaixa)**
```
1. "Iniciar Pagamento" → Simula pagamento de 5.000 Kz
   - Retorna transacaoId (MCX-{timestamp})
   
2. "Verificar Status de Pagamento" → Status: "pendente"
   
3. "Webhook Multicaixa" → Simula confirmação da Multicaixa
   - Mudar campo "status" para "aprovado"
   - Backend processa e atualiza estado
   
4. "Calcular Taxa da Plataforma" → 2.5% de 100.000 Kz = 2.500 Kz
```

**Fluxo Webhook:**
1. Iniciar pagamento (guarda transacaoId)
2. Enviar webhook com status "aprovado"
3. Verificar status novamente → Deve estar "aprovado"

---

#### 5️⃣ **Módulo Serviços (Turismo/Seguros)**

**Reservas:**
```
1. "Criar Reserva - Restaurante" → Mesa para 4 pessoas
2. "Criar Reserva - Guia Turístico" → Tour Fortaleza
3. "Listar Reservas do Utilizador" → Ver todas as reservas
```

**Seguros:**
```
1. "Solicitar Cotação - Seguro Automóvel" → Carro 2022
   - Cotação instantânea: ~23.000 Kz/mês (algoritmo age-based)
   
2. "Solicitar Cotação - Seguro Residencial" → Sem veículo
   
3. "Obter Detalhes de Cotação" → Ver cotação completa
```

**Testar Pricing de Seguros:**
- Carro 2022 (4 anos) → 15.000 Kz base = 15.000 Kz/mês
- Carro 2014 (12 anos, >10) → 15.000 + 5.000 = 20.000 Kz/mês
- Carro 2024 (2 anos, <3) → 15.000 + 8.000 = 23.000 Kz/mês

---

## 🔐 Autenticação Automática

Todos os endpoints protegidos usam **Bearer Token** do environment.

Após executar "Registar Vendedor" ou "Login", o script de teste automaticamente:
1. Extrai o `token` da resposta JSON
2. Guarda em `{{jwt_token}}`
3. Todos os requests seguintes usam esse token no header:
   ```
   Authorization: Bearer {{jwt_token}}
   ```

**Se token expirar (7 dias):**
- Executar "Login" novamente com email/senha do registo

---

## 🐛 Troubleshooting

### ❌ Erro "Connection refused"
```bash
# Verificar se backend está a correr:
netstat -ano | findstr ":3000" | findstr "LISTENING"

# Se não estiver, iniciar:
cd backend
npm run start:dev
```

### ❌ Erro 401 Unauthorized
- Token JWT expirou ou inválido
- Executar "Login" novamente
- Verificar se environment está ativo (dropdown superior direito)

### ❌ Erro 400 Bad Request (Upload de ficheiros)
- Verificar se o caminho do ficheiro no body está correto
- Tamanho máximo: 5MB por foto
- Formatos suportados: JPG, PNG
- Máximo 10 fotos por anúncio

### ❌ Erro "PostGIS não está instalado"
```sql
-- No PostgreSQL:
CREATE EXTENSION IF NOT EXISTS postgis;
```

---

## 📊 Scripts de Teste Automatizados

A coleção inclui scripts no **Tests tab** de alguns requests:

**"Registar Vendedor":**
```javascript
if (pm.response.code === 201) {
    const jsonData = pm.response.json();
    pm.environment.set('jwt_token', jsonData.token);
    pm.environment.set('user_id', jsonData.user.id);
}
```

**"Criar Anúncio - Imóvel":**
```javascript
if (pm.response.code === 201) {
    const jsonData = pm.response.json();
    pm.environment.set('anuncio_id', jsonData.anuncio.id);
}
```

**"Calcular Estimativa de Entrega":**
```javascript
pm.test('Cálculo Haversine funciona', () => {
    const jsonData = pm.response.json();
    pm.expect(jsonData.distanciaKm).to.be.above(0);
    pm.expect(jsonData.precoEntrega).to.be.above(500);
});
```

---

## 🚀 Próximos Passos

Depois de testar todas as APIs:

1. **Criar Interface Flutter:** Mobile app para Android/iOS
2. **Integrar APIs Reais:** Tupuca, Multicaixa, ENSA Seguros
3. **Adicionar Firebase:** Push notifications e chat em tempo real
4. **Deploy:** Migrar para produção (AWS/Azure)

---

**Backend rodando em:** http://localhost:3000/api/v1
**Documentação completa:** [API_ENDPOINTS.md](./API_ENDPOINTS.md)
