# TudoAqui Backend - NestJS Microservices

## Estrutura de Microserviços (2026)

```
backend/
├── src/
│   ├── main.ts                          # Bootstrap da aplicação
│   ├── app.module.ts                    # Módulo raiz
│   └── modules/
│       ├── auth/                        # Google Identity / Auth0
│       │   ├── auth.module.ts
│       │   ├── auth.controller.ts
│       │   ├── auth.service.ts
│       │   ├── entities/user.entity.ts
│       │   └── strategies/
│       │       ├── jwt.strategy.ts
│       │       └── google.strategy.ts
│       ├── kyc/                         # Amazon Rekognition / Vision AI
│       │   ├── kyc.module.ts
│       │   ├── kyc.controller.ts
│       │   └── kyc.service.ts
│       ├── marketplace/                 # Imóveis, Automóveis, Turismo
│       ├── logistica/                   # Tupuca Integration
│       └── pagamentos/                  # Multicaixa Express + GPO
├── .env.example
└── package.json
```

## Tech Stack

- **NestJS 10.3+** (TypeScript obrigatório)
- **PostgreSQL** (TypeORM)
- **Redis** (GPS em tempo real)
- **Firebase Admin SDK** (Push notifications)
- **AWS SDK** (Amazon Rekognition para KYC)

## Instalação

```bash
cd backend
npm install
```

## Configuração

1. Copiar `.env.example` para `.env`:
```bash
cp .env.example .env
```

2. Configurar variáveis de ambiente:
- Credenciais Google Identity / Auth0
- AWS Access Keys para Rekognition
- Firebase Service Account
- APIs de Tupuca, Multicaixa, GPO

## Executar

```bash
# Desenvolvimento (hot-reload)
npm run start:dev

# Produção
npm run build
npm run start:prod
```

O backend estará disponível em `http://localhost:3000/api/v1`

## Endpoints Principais

### Autenticação
- `POST /api/v1/auth/register` - Registo
- `POST /api/v1/auth/login` - Login
- `POST /api/v1/auth/google` - Login via Google
- `POST /api/v1/auth/2fa/send` - Enviar código 2FA
- `POST /api/v1/auth/2fa/verify` - Verificar 2FA

### KYC (Know Your Customer)
- `POST /api/v1/kyc/upload-bi` - Upload de BI
- `POST /api/v1/kyc/upload-selfie` - Selfie + Liveness Detection
- `POST /api/v1/kyc/upload-alvara` - Alvará (Business)
- `GET /api/v1/kyc/status/:userId` - Estado da verificação
- `POST /api/v1/kyc/analyze` - Análise com Amazon Rekognition

## Arquitetura de Microserviços

Cada módulo (`auth`, `kyc`, `marketplace`, etc.) funciona de forma independente:

- **Benefício:** Se o módulo de "Restaurantes" falhar, o de "Automóveis" continua ativo
- **Escalabilidade:** Cada microserviço pode ter sua própria réplica
- **Manutenção:** Equipes diferentes podem trabalhar em módulos diferentes

## Segurança

### Nível Bancário (2026)
1. **TypeScript Obrigatório:** Prevenção de erros em runtime
2. **Validação Automática:** `class-validator` em todos os DTOs
3. **JWT com Expiração:** Tokens expiram em 7 dias
4. **CORS Restrito:** Apenas domínios autorizados
5. **Rate Limiting:** Proteção contra DDoS (a implementar)

### KYC Anti-Fraude
1. **Liveness Detection:** Amazon Rekognition detecta foto de foto
2. **Face Matching:** Comparação entre BI e selfie (score > 95%)
3. **OCR de BI:** Extração automática do número do BI
4. **Marca d'água:** Watermark "TudoAqui" em todos os documentos

## Próximos Passos

- [ ] Implementar Redis para cache de GPS
- [ ] Integrar Amazon Rekognition SDK
- [ ] Configurar Firebase Admin para notificações
- [ ] Criar endpoints de Marketplace (Imóveis, Automóveis)
- [ ] Integrar APIs angolanas (Tupuca, Multicaixa, GPO)
