"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const typeorm_1 = require("@nestjs/typeorm");
const auth_module_1 = require("./modules/auth/auth.module");
const kyc_module_1 = require("./modules/kyc/kyc.module");
const marketplace_module_1 = require("./modules/marketplace/marketplace.module");
const logistica_module_1 = require("./modules/logistica/logistica.module");
const pagamentos_module_1 = require("./modules/pagamentos/pagamentos.module");
const servicos_module_1 = require("./modules/servicos/servicos.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({
                isGlobal: true,
            }),
            typeorm_1.TypeOrmModule.forRoot({
                type: 'postgres',
                host: process.env.DB_HOST || 'localhost',
                port: Number.parseInt(process.env.DB_PORT ?? '5432', 10),
                username: process.env.DB_USER || 'postgres',
                password: process.env.DB_PASSWORD || 'postgres',
                database: process.env.DB_NAME || 'tudoaqui',
                autoLoadEntities: true,
                synchronize: process.env.NODE_ENV !== 'production',
                logging: process.env.NODE_ENV === 'development',
            }),
            auth_module_1.AuthModule,
            kyc_module_1.KycModule,
            marketplace_module_1.MarketplaceModule,
            logistica_module_1.LogisticaModule,
            pagamentos_module_1.PagamentosModule,
            servicos_module_1.ServicosModule,
        ],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map