"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AllExceptionsFilter = void 0;
const common_1 = require("@nestjs/common");
let AllExceptionsFilter = class AllExceptionsFilter {
    catch(exception, host) {
        const ctx = host.switchToHttp();
        const response = ctx.getResponse();
        const request = ctx.getRequest();
        console.error('========================================');
        console.error('❌ ERRO CAPTURADO PELO EXCEPTION FILTER');
        console.error('========================================');
        console.error('Timestamp:', new Date().toISOString());
        console.error('Path:', request.url);
        console.error('Method:', request.method);
        console.error('Body:', JSON.stringify(request.body, null, 2));
        console.error('');
        console.error('Erro:');
        console.error('  Message:', exception.message);
        console.error('  Name:', exception.name);
        console.error('  Code:', exception.code);
        console.error('  Detail:', exception.detail);
        console.error('');
        console.error('Stack:', exception.stack);
        console.error('========================================');
        const status = exception instanceof common_1.HttpException
            ? exception.getStatus()
            : common_1.HttpStatus.INTERNAL_SERVER_ERROR;
        const errorResponse = {
            statusCode: status,
            timestamp: new Date().toISOString(),
            path: request.url,
            message: exception.message || 'Internal server error',
            error: exception.name || 'Error',
            ...(process.env.NODE_ENV === 'development' && {
                detail: exception.detail,
                code: exception.code,
                stack: exception.stack,
            }),
        };
        response.status(status).json(errorResponse);
    }
};
exports.AllExceptionsFilter = AllExceptionsFilter;
exports.AllExceptionsFilter = AllExceptionsFilter = __decorate([
    (0, common_1.Catch)()
], AllExceptionsFilter);
//# sourceMappingURL=all-exceptions.filter.js.map