import { AuthService } from './auth.service';
import { RegisterDto } from './dto/register.dto';
import { LoginDto } from './dto/login.dto';
export declare class AuthController {
    private readonly authService;
    constructor(authService: AuthService);
    register(registerDto: RegisterDto): Promise<{
        message: string;
        token: string;
        user: {
            id: string;
            nome: string;
            email: string;
            tipo: string;
            seloVerificado: boolean;
        };
    }>;
    login(loginDto: LoginDto): Promise<{
        token: string;
        user: {
            id: string;
            nome: string;
            email: string;
            tipo: string;
            seloVerificado: boolean;
        };
    }>;
    getProfile(req: any): any;
    googleAuth(body: {
        idToken: string;
    }): Promise<{
        message: string;
    }>;
    send2FA(body: {
        telefone: string;
    }): Promise<{
        message: string;
    }>;
    verify2FA(body: {
        telefone: string;
        codigo: string;
    }): Promise<{
        message: string;
    }>;
}
