import { Repository } from 'typeorm';
import { JwtService } from '@nestjs/jwt';
import { User } from './entities/user.entity';
import { RegisterDto } from './dto/register.dto';
import { LoginDto } from './dto/login.dto';
export declare class AuthService {
    private readonly userRepository;
    private readonly jwtService;
    constructor(userRepository: Repository<User>, jwtService: JwtService);
    register(registerDto: RegisterDto): Promise<{
        message: string;
        token: string;
        user: {
            id: string;
            nome: string;
            email: string;
            tipo: string;
            seloVerificado: boolean;
        };
    }>;
    login(loginDto: LoginDto): Promise<{
        token: string;
        user: {
            id: string;
            nome: string;
            email: string;
            tipo: string;
            seloVerificado: boolean;
        };
    }>;
    googleLogin(idToken: string): Promise<{
        message: string;
    }>;
    sendTwoFactorCode(telefone: string): Promise<{
        message: string;
    }>;
    verifyTwoFactorCode(telefone: string, codigo: string): Promise<{
        message: string;
    }>;
    validateUser(userId: string): Promise<User | null>;
}
