"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const jwt_1 = require("@nestjs/jwt");
const user_entity_1 = require("./entities/user.entity");
const bcrypt = __importStar(require("bcrypt"));
let AuthService = class AuthService {
    constructor(userRepository, jwtService) {
        this.userRepository = userRepository;
        this.jwtService = jwtService;
    }
    async register(registerDto) {
        try {
            const { email, senha, nome, telefone, tipo } = registerDto;
            const userExists = await this.userRepository.findOne({ where: { email } });
            if (userExists) {
                throw new common_1.UnauthorizedException('Email já registado');
            }
            const phoneExists = await this.userRepository.findOne({ where: { telefone } });
            if (phoneExists) {
                throw new common_1.UnauthorizedException('Telefone já registado');
            }
            const senhaHash = await bcrypt.hash(senha, 10);
            const user = this.userRepository.create({
                email,
                senha: senhaHash,
                nome,
                telefone,
                tipo,
                seloVerificado: false,
                kycStatus: 'pendente',
            });
            await this.userRepository.save(user);
            const token = this.jwtService.sign({ sub: user.id, email: user.email });
            return {
                message: 'Utilizador criado com sucesso',
                token,
                user: {
                    id: user.id,
                    nome: user.nome,
                    email: user.email,
                    tipo: user.tipo,
                    seloVerificado: user.seloVerificado,
                },
            };
        }
        catch (error) {
            console.error('❌ Erro no registo:', error.message);
            console.error('   Stack:', error.stack);
            if (error instanceof common_1.UnauthorizedException) {
                throw error;
            }
            if (error.code === '23505') {
                if (error.detail.includes('email')) {
                    throw new common_1.UnauthorizedException('Email já registado');
                }
                if (error.detail.includes('telefone')) {
                    throw new common_1.UnauthorizedException('Telefone já registado');
                }
            }
            throw new Error(`Erro ao criar utilizador: ${error.message}`);
        }
    }
    async login(loginDto) {
        const { email, senha } = loginDto;
        const user = await this.userRepository.findOne({ where: { email } });
        if (!user) {
            throw new common_1.UnauthorizedException('Credenciais inválidas');
        }
        const senhaValida = await bcrypt.compare(senha, user.senha);
        if (!senhaValida) {
            throw new common_1.UnauthorizedException('Credenciais inválidas');
        }
        const token = this.jwtService.sign({ sub: user.id, email: user.email });
        return {
            token,
            user: {
                id: user.id,
                nome: user.nome,
                email: user.email,
                tipo: user.tipo,
                seloVerificado: user.seloVerificado,
            },
        };
    }
    async googleLogin(idToken) {
        return { message: 'Google login - a implementar' };
    }
    async sendTwoFactorCode(telefone) {
        const codigo = Math.floor(100000 + Math.random() * 900000).toString();
        console.log(`Código 2FA para ${telefone}: ${codigo}`);
        return { message: 'Código enviado via SMS' };
    }
    async verifyTwoFactorCode(telefone, codigo) {
        return { message: 'Código verificado com sucesso' };
    }
    async validateUser(userId) {
        return this.userRepository.findOne({ where: { id: userId } });
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        jwt_1.JwtService])
], AuthService);
//# sourceMappingURL=auth.service.js.map