import { KycService } from './kyc.service';
export declare class KycController {
    private readonly kycService;
    constructor(kycService: KycService);
    uploadBI(file: Express.Multer.File, userId: string): Promise<{
        message: string;
        url: string;
        dadosExtraidos: {
            nome?: string;
            numeroBI?: string;
        };
    }>;
    uploadSelfie(file: Express.Multer.File, userId: string): Promise<{
        message: string;
        url: string;
        livenessDetected: boolean;
    }>;
    uploadAlvara(file: Express.Multer.File, userId: string): Promise<{
        message: string;
        url: string;
    }>;
    getKycStatus(userId: string): Promise<{
        kycStatus: string;
        seloVerificado: boolean;
        biEnviado: boolean;
        selfieEnviada: boolean;
        numeroBI: string | null;
    }>;
    analyzeDocuments(userId: string): Promise<{
        message: string;
        validacoes: {
            nomeCoincide: boolean;
            rostosCorrespondem: boolean;
            aprovado: boolean;
        };
        seloVerificado: boolean;
    }>;
}
