import { Repository } from 'typeorm';
import { User } from '../auth/entities/user.entity';
export declare class KycService {
    private readonly userRepository;
    private readonly visionClient;
    constructor(userRepository: Repository<User>);
    processBI(userId: string, file: Express.Multer.File): Promise<{
        message: string;
        url: string;
        dadosExtraidos: {
            nome?: string;
            numeroBI?: string;
        };
    }>;
    processSelfie(userId: string, file: Express.Multer.File): Promise<{
        message: string;
        url: string;
        livenessDetected: boolean;
    }>;
    analyzeWithAI(userId: string): Promise<{
        message: string;
        validacoes: {
            nomeCoincide: boolean;
            rostosCorrespondem: boolean;
            aprovado: boolean;
        };
        seloVerificado: boolean;
    }>;
    getKycStatus(userId: string): Promise<{
        kycStatus: string;
        seloVerificado: boolean;
        biEnviado: boolean;
        selfieEnviada: boolean;
        numeroBI: string | null;
    }>;
    private extractBIData;
    private verifyLiveness;
    private compareFaces;
    private compareNames;
    private addWatermark;
    private ensureDir;
    processAlvara(userId: string, file: Express.Multer.File): Promise<{
        message: string;
        url: string;
    }>;
}
