"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogisticaController = void 0;
const common_1 = require("@nestjs/common");
const tupuca_service_1 = require("./tupuca.service");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
let LogisticaController = class LogisticaController {
    constructor(tupucaService) {
        this.tupucaService = tupucaService;
    }
    async calcularEstimativa(dados) {
        return this.tupucaService.calcularEstimativaEntrega(dados);
    }
    async criarPedido(req, dados) {
        return this.tupucaService.criarPedidoEntrega(dados.pedidoId, dados.origem, dados.destino);
    }
    async rastrearEntrega(trackingId) {
        return this.tupucaService.rastrearEntrega(trackingId);
    }
};
exports.LogisticaController = LogisticaController;
__decorate([
    (0, common_1.Post)('estimativa'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LogisticaController.prototype, "calcularEstimativa", null);
__decorate([
    (0, common_1.Post)('pedido'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], LogisticaController.prototype, "criarPedido", null);
__decorate([
    (0, common_1.Get)('rastrear/:trackingId'),
    __param(0, (0, common_1.Param)('trackingId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], LogisticaController.prototype, "rastrearEntrega", null);
exports.LogisticaController = LogisticaController = __decorate([
    (0, common_1.Controller)('logistica'),
    __metadata("design:paramtypes", [tupuca_service_1.TupucaService])
], LogisticaController);
//# sourceMappingURL=logistica.controller.js.map