import { ConfigService } from '@nestjs/config';
interface EstimativaEntregaDto {
    restauranteLatitude: number;
    restauranteLongitude: number;
    clienteLatitude: number;
    clienteLongitude: number;
}
interface EstimativaResponse {
    distanciaKm: number;
    tempoEstimadoMinutos: number;
    precoEntrega: number;
    disponivel: boolean;
}
export declare class TupucaService {
    private readonly configService;
    private readonly apiKey;
    private readonly baseUrl;
    constructor(configService: ConfigService);
    calcularEstimativaEntrega(dados: EstimativaEntregaDto): Promise<EstimativaResponse>;
    criarPedidoEntrega(pedidoId: string, origem: any, destino: any): Promise<{
        success: boolean;
        trackingId: string;
        message: string;
    }>;
    rastrearEntrega(trackingId: string): Promise<{
        trackingId: string;
        status: string;
        latitude: number;
        longitude: number;
        tempoRestante: number;
    }>;
    private calcularDistanciaHaversine;
    private toRad;
}
export {};
