"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TupucaService = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
let TupucaService = class TupucaService {
    constructor(configService) {
        this.configService = configService;
        this.apiKey = this.configService.get('TUPUCA_API_KEY') || 'mock-api-key-dev';
        this.baseUrl = this.configService.get('TUPUCA_BASE_URL') || 'https://api.tupuca.ao';
    }
    async calcularEstimativaEntrega(dados) {
        try {
            const distanciaKm = this.calcularDistanciaHaversine(dados.restauranteLatitude, dados.restauranteLongitude, dados.clienteLatitude, dados.clienteLongitude);
            const precoBase = 500;
            const precoPorKm = 150;
            const precoEntrega = precoBase + (distanciaKm * precoPorKm);
            const tempoEstimadoMinutos = Math.ceil((distanciaKm * 5) + 10);
            const disponivel = distanciaKm <= 15;
            return {
                distanciaKm: Number(distanciaKm.toFixed(2)),
                tempoEstimadoMinutos,
                precoEntrega: Math.ceil(precoEntrega),
                disponivel,
            };
        }
        catch (error) {
            console.error('Erro ao calcular estimativa Tupuca:', error);
            throw new common_1.HttpException('Erro ao calcular estimativa de entrega', common_1.HttpStatus.SERVICE_UNAVAILABLE);
        }
    }
    async criarPedidoEntrega(pedidoId, origem, destino) {
        console.log('📦 Pedido de entrega criado (MOCK):', { pedidoId, origem, destino });
        return {
            success: true,
            trackingId: `TUPUCA-${Date.now()}`,
            message: 'Entregador a caminho (funcionalidade em desenvolvimento)',
        };
    }
    async rastrearEntrega(trackingId) {
        return {
            trackingId,
            status: 'em_rota',
            latitude: -8.8383,
            longitude: 13.2344,
            tempoRestante: 15,
        };
    }
    calcularDistanciaHaversine(lat1, lon1, lat2, lon2) {
        const R = 6371;
        const dLat = this.toRad(lat2 - lat1);
        const dLon = this.toRad(lon2 - lon1);
        const a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
            Math.cos(this.toRad(lat1)) * Math.cos(this.toRad(lat2)) *
                Math.sin(dLon / 2) * Math.sin(dLon / 2);
        const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
        return R * c;
    }
    toRad(degrees) {
        return degrees * (Math.PI / 180);
    }
};
exports.TupucaService = TupucaService;
exports.TupucaService = TupucaService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], TupucaService);
//# sourceMappingURL=tupuca.service.js.map