import { Point } from 'typeorm';
import { User } from '../../auth/entities/user.entity';
export declare enum CategoriaAnuncio {
    IMOVEIS = "imoveis",
    VEICULOS = "veiculos",
    TURISMO = "turismo",
    SERVICOS = "servicos"
}
export declare enum StatusAnuncio {
    PENDENTE = "pendente",
    ATIVO = "ativo",
    VENDIDO = "vendido",
    REMOVIDO = "removido"
}
export declare class Anuncio {
    id: string;
    vendedor: User;
    vendedorId: string;
    categoria: CategoriaAnuncio;
    titulo: string;
    descricao: string;
    preco: number;
    provincia: string;
    municipio: string;
    bairro: string;
    endereco: string;
    localizacao: Point;
    fotos: string[];
    fotosOriginais: string[];
    status: StatusAnuncio;
    visualizacoes: number;
    destaque: boolean;
    createdAt: Date;
    updatedAt: Date;
}
