"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Anuncio = exports.StatusAnuncio = exports.CategoriaAnuncio = void 0;
const typeorm_1 = require("typeorm");
const user_entity_1 = require("../../auth/entities/user.entity");
var CategoriaAnuncio;
(function (CategoriaAnuncio) {
    CategoriaAnuncio["IMOVEIS"] = "imoveis";
    CategoriaAnuncio["VEICULOS"] = "veiculos";
    CategoriaAnuncio["TURISMO"] = "turismo";
    CategoriaAnuncio["SERVICOS"] = "servicos";
})(CategoriaAnuncio || (exports.CategoriaAnuncio = CategoriaAnuncio = {}));
var StatusAnuncio;
(function (StatusAnuncio) {
    StatusAnuncio["PENDENTE"] = "pendente";
    StatusAnuncio["ATIVO"] = "ativo";
    StatusAnuncio["VENDIDO"] = "vendido";
    StatusAnuncio["REMOVIDO"] = "removido";
})(StatusAnuncio || (exports.StatusAnuncio = StatusAnuncio = {}));
let Anuncio = class Anuncio {
};
exports.Anuncio = Anuncio;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], Anuncio.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.User),
    (0, typeorm_1.JoinColumn)({ name: 'vendedor_id' }),
    __metadata("design:type", user_entity_1.User)
], Anuncio.prototype, "vendedor", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Anuncio.prototype, "vendedorId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: CategoriaAnuncio }),
    __metadata("design:type", String)
], Anuncio.prototype, "categoria", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Anuncio.prototype, "titulo", void 0);
__decorate([
    (0, typeorm_1.Column)('text'),
    __metadata("design:type", String)
], Anuncio.prototype, "descricao", void 0);
__decorate([
    (0, typeorm_1.Column)('decimal', { precision: 12, scale: 2 }),
    __metadata("design:type", Number)
], Anuncio.prototype, "preco", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Anuncio.prototype, "provincia", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Anuncio.prototype, "municipio", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Anuncio.prototype, "bairro", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Anuncio.prototype, "endereco", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'geography',
        spatialFeatureType: 'Point',
        srid: 4326,
        nullable: true,
    }),
    __metadata("design:type", Object)
], Anuncio.prototype, "localizacao", void 0);
__decorate([
    (0, typeorm_1.Column)('simple-array', { nullable: true }),
    __metadata("design:type", Array)
], Anuncio.prototype, "fotos", void 0);
__decorate([
    (0, typeorm_1.Column)('simple-array', { nullable: true }),
    __metadata("design:type", Array)
], Anuncio.prototype, "fotosOriginais", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: StatusAnuncio, default: StatusAnuncio.PENDENTE }),
    __metadata("design:type", String)
], Anuncio.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], Anuncio.prototype, "visualizacoes", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: false }),
    __metadata("design:type", Boolean)
], Anuncio.prototype, "destaque", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Anuncio.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], Anuncio.prototype, "updatedAt", void 0);
exports.Anuncio = Anuncio = __decorate([
    (0, typeorm_1.Entity)('anuncios')
], Anuncio);
//# sourceMappingURL=anuncio.entity.js.map