import { MarketplaceService } from './marketplace.service';
import { CriarAnuncioDto, FiltrosAnuncioDto } from './dto/criar-anuncio.dto';
export declare class MarketplaceController {
    private readonly marketplaceService;
    constructor(marketplaceService: MarketplaceService);
    criarAnuncio(req: any, dto: CriarAnuncioDto, fotos: Express.Multer.File[]): Promise<{
        message: string;
        anuncio: {
            id: string;
            titulo: string;
            preco: number;
            fotos: string[];
        };
    }>;
    listarAnuncios(filtros: FiltrosAnuncioDto): Promise<{
        total: number;
        anuncios: {
            id: string;
            titulo: string;
            preco: number;
            provincia: string;
            municipio: string;
            fotos: string[];
            destaque: boolean;
            vendedor: {
                nome: string;
                seloVerificado: boolean;
            };
        }[];
    }>;
    obterAnuncio(id: string): Promise<{
        detalhes: import("./entities/detalhes-imovel.entity").DetalhesImovel | import("./entities/detalhes-veiculo.entity").DetalhesVeiculo | null;
        vendedor: {
            id: string;
            nome: string;
            telefone: string;
            seloVerificado: boolean;
        };
        id: string;
        vendedorId: string;
        categoria: import("./entities/anuncio.entity").CategoriaAnuncio;
        titulo: string;
        descricao: string;
        preco: number;
        provincia: string;
        municipio: string;
        bairro: string;
        endereco: string;
        localizacao: import("typeorm").Point;
        fotos: string[];
        fotosOriginais: string[];
        status: import("./entities/anuncio.entity").StatusAnuncio;
        visualizacoes: number;
        destaque: boolean;
        createdAt: Date;
        updatedAt: Date;
    }>;
    buscarPorLocalidade(provincia: string, municipio: string, filtros: FiltrosAnuncioDto): Promise<{
        total: number;
        anuncios: {
            id: string;
            titulo: string;
            preco: number;
            provincia: string;
            municipio: string;
            fotos: string[];
            destaque: boolean;
            vendedor: {
                nome: string;
                seloVerificado: boolean;
            };
        }[];
    }>;
}
