"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarketplaceController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const marketplace_service_1 = require("./marketplace.service");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const criar_anuncio_dto_1 = require("./dto/criar-anuncio.dto");
let MarketplaceController = class MarketplaceController {
    constructor(marketplaceService) {
        this.marketplaceService = marketplaceService;
    }
    async criarAnuncio(req, dto, fotos) {
        return this.marketplaceService.criarAnuncio(req.user.userId, dto, fotos);
    }
    async listarAnuncios(filtros) {
        return this.marketplaceService.listarAnuncios(filtros);
    }
    async obterAnuncio(id) {
        return this.marketplaceService.obterAnuncio(id);
    }
    async buscarPorLocalidade(provincia, municipio, filtros) {
        return this.marketplaceService.listarAnuncios({
            ...filtros,
            provincia,
            municipio,
        });
    }
};
exports.MarketplaceController = MarketplaceController;
__decorate([
    (0, common_1.Post)('anuncios'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.UseInterceptors)((0, platform_express_1.FilesInterceptor)('fotos', 10, {
        limits: { fileSize: 5 * 1024 * 1024 },
        fileFilter: (req, file, cb) => {
            if (!file.mimetype.match(/\/(jpg|jpeg|png)$/)) {
                return cb(new Error('Apenas imagens JPG/PNG são permitidas'), false);
            }
            cb(null, true);
        },
    })),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.UploadedFiles)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, criar_anuncio_dto_1.CriarAnuncioDto, Array]),
    __metadata("design:returntype", Promise)
], MarketplaceController.prototype, "criarAnuncio", null);
__decorate([
    (0, common_1.Get)('anuncios'),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [criar_anuncio_dto_1.FiltrosAnuncioDto]),
    __metadata("design:returntype", Promise)
], MarketplaceController.prototype, "listarAnuncios", null);
__decorate([
    (0, common_1.Get)('anuncios/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], MarketplaceController.prototype, "obterAnuncio", null);
__decorate([
    (0, common_1.Get)('anuncios/localidade/:provincia/:municipio'),
    __param(0, (0, common_1.Param)('provincia')),
    __param(1, (0, common_1.Param)('municipio')),
    __param(2, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, criar_anuncio_dto_1.FiltrosAnuncioDto]),
    __metadata("design:returntype", Promise)
], MarketplaceController.prototype, "buscarPorLocalidade", null);
exports.MarketplaceController = MarketplaceController = __decorate([
    (0, common_1.Controller)('marketplace'),
    __metadata("design:paramtypes", [marketplace_service_1.MarketplaceService])
], MarketplaceController);
//# sourceMappingURL=marketplace.controller.js.map