import { Repository } from 'typeorm';
import { Anuncio, CategoriaAnuncio, StatusAnuncio } from './entities/anuncio.entity';
import { DetalhesImovel } from './entities/detalhes-imovel.entity';
import { DetalhesVeiculo } from './entities/detalhes-veiculo.entity';
import { CriarAnuncioDto, FiltrosAnuncioDto } from './dto/criar-anuncio.dto';
export declare class MarketplaceService {
    private readonly anuncioRepository;
    private readonly detalhesImovelRepository;
    private readonly detalhesVeiculoRepository;
    constructor(anuncioRepository: Repository<Anuncio>, detalhesImovelRepository: Repository<DetalhesImovel>, detalhesVeiculoRepository: Repository<DetalhesVeiculo>);
    criarAnuncio(userId: string, dto: CriarAnuncioDto, fotos: Express.Multer.File[]): Promise<{
        message: string;
        anuncio: {
            id: string;
            titulo: string;
            preco: number;
            fotos: string[];
        };
    }>;
    listarAnuncios(filtros: FiltrosAnuncioDto): Promise<{
        total: number;
        anuncios: {
            id: string;
            titulo: string;
            preco: number;
            provincia: string;
            municipio: string;
            fotos: string[];
            destaque: boolean;
            vendedor: {
                nome: string;
                seloVerificado: boolean;
            };
        }[];
    }>;
    obterAnuncio(id: string): Promise<{
        detalhes: DetalhesImovel | DetalhesVeiculo | null;
        vendedor: {
            id: string;
            nome: string;
            telefone: string;
            seloVerificado: boolean;
        };
        id: string;
        vendedorId: string;
        categoria: CategoriaAnuncio;
        titulo: string;
        descricao: string;
        preco: number;
        provincia: string;
        municipio: string;
        bairro: string;
        endereco: string;
        localizacao: import("typeorm").Point;
        fotos: string[];
        fotosOriginais: string[];
        status: StatusAnuncio;
        visualizacoes: number;
        destaque: boolean;
        createdAt: Date;
        updatedAt: Date;
    }>;
    private aplicarMarcaDagua;
}
