"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarketplaceService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const sharp_1 = __importDefault(require("sharp"));
const promises_1 = require("node:fs/promises");
const node_path_1 = require("node:path");
const anuncio_entity_1 = require("./entities/anuncio.entity");
const detalhes_imovel_entity_1 = require("./entities/detalhes-imovel.entity");
const detalhes_veiculo_entity_1 = require("./entities/detalhes-veiculo.entity");
let MarketplaceService = class MarketplaceService {
    constructor(anuncioRepository, detalhesImovelRepository, detalhesVeiculoRepository) {
        this.anuncioRepository = anuncioRepository;
        this.detalhesImovelRepository = detalhesImovelRepository;
        this.detalhesVeiculoRepository = detalhesVeiculoRepository;
    }
    async criarAnuncio(userId, dto, fotos) {
        const fotosComMarcaDagua = await Promise.all(fotos.map(foto => this.aplicarMarcaDagua(foto.buffer, foto.originalname)));
        const anuncio = this.anuncioRepository.create({
            vendedorId: userId,
            categoria: dto.categoria,
            titulo: dto.titulo,
            descricao: dto.descricao,
            preco: dto.preco,
            provincia: dto.provincia,
            municipio: dto.municipio,
            bairro: dto.bairro,
            endereco: dto.endereco,
            localizacao: dto.latitude && dto.longitude
                ? { type: 'Point', coordinates: [dto.longitude, dto.latitude] }
                : null,
            fotos: fotosComMarcaDagua.map(f => f.urlComMarca),
            fotosOriginais: fotosComMarcaDagua.map(f => f.urlOriginal),
            status: anuncio_entity_1.StatusAnuncio.ATIVO,
        });
        await this.anuncioRepository.save(anuncio);
        if (dto.categoria === anuncio_entity_1.CategoriaAnuncio.IMOVEIS && dto.tipoImovel) {
            const detalhes = this.detalhesImovelRepository.create({
                anuncioId: anuncio.id,
                tipo: dto.tipoImovel,
                tipoNegocio: dto.tipoNegocio,
                quartos: dto.quartos,
                banheiros: dto.banheiros,
                garagem: dto.garagem,
                area: dto.area,
                mobilado: dto.mobilado,
                piscina: dto.piscina,
            });
            await this.detalhesImovelRepository.save(detalhes);
        }
        if (dto.categoria === anuncio_entity_1.CategoriaAnuncio.VEICULOS && dto.tipoVeiculo) {
            const detalhes = this.detalhesVeiculoRepository.create({
                anuncioId: anuncio.id,
                tipo: dto.tipoVeiculo,
                marca: dto.marca,
                modelo: dto.modelo,
                ano: dto.ano,
                combustivel: dto.combustivel,
                transmissao: dto.transmissao,
                quilometragem: dto.quilometragem,
                cor: dto.cor,
            });
            await this.detalhesVeiculoRepository.save(detalhes);
        }
        return {
            message: 'Anúncio criado com sucesso',
            anuncio: {
                id: anuncio.id,
                titulo: anuncio.titulo,
                preco: anuncio.preco,
                fotos: anuncio.fotos,
            },
        };
    }
    async listarAnuncios(filtros) {
        const query = this.anuncioRepository
            .createQueryBuilder('anuncio')
            .leftJoinAndSelect('anuncio.vendedor', 'vendedor')
            .where('anuncio.status = :status', { status: anuncio_entity_1.StatusAnuncio.ATIVO })
            .orderBy('anuncio.destaque', 'DESC')
            .addOrderBy('anuncio.createdAt', 'DESC');
        if (filtros.categoria) {
            query.andWhere('anuncio.categoria = :categoria', { categoria: filtros.categoria });
        }
        if (filtros.provincia) {
            query.andWhere('anuncio.provincia = :provincia', { provincia: filtros.provincia });
        }
        if (filtros.municipio) {
            query.andWhere('anuncio.municipio = :municipio', { municipio: filtros.municipio });
        }
        if (filtros.precoMin) {
            query.andWhere('anuncio.preco >= :precoMin', { precoMin: filtros.precoMin });
        }
        if (filtros.precoMax) {
            query.andWhere('anuncio.preco <= :precoMax', { precoMax: filtros.precoMax });
        }
        if (filtros.busca) {
            query.andWhere('(anuncio.titulo ILIKE :busca OR anuncio.descricao ILIKE :busca)', {
                busca: `%${filtros.busca}%`,
            });
        }
        if (filtros.latitude && filtros.longitude && filtros.raioKm) {
            const raioMetros = filtros.raioKm * 1000;
            query.andWhere(`ST_DWithin(anuncio.localizacao, ST_SetSRID(ST_MakePoint(:lng, :lat), 4326)::geography, :raio)`, {
                lat: filtros.latitude,
                lng: filtros.longitude,
                raio: raioMetros,
            });
        }
        const anuncios = await query.getMany();
        return {
            total: anuncios.length,
            anuncios: anuncios.map(a => ({
                id: a.id,
                titulo: a.titulo,
                preco: a.preco,
                provincia: a.provincia,
                municipio: a.municipio,
                fotos: a.fotos.slice(0, 1),
                destaque: a.destaque,
                vendedor: {
                    nome: a.vendedor.nome,
                    seloVerificado: a.vendedor.seloVerificado,
                },
            })),
        };
    }
    async obterAnuncio(id) {
        const anuncio = await this.anuncioRepository.findOne({
            where: { id },
            relations: ['vendedor'],
        });
        if (!anuncio) {
            throw new common_1.NotFoundException('Anúncio não encontrado');
        }
        await this.anuncioRepository.update(id, {
            visualizacoes: anuncio.visualizacoes + 1,
        });
        let detalhes = null;
        if (anuncio.categoria === anuncio_entity_1.CategoriaAnuncio.IMOVEIS) {
            detalhes = await this.detalhesImovelRepository.findOne({
                where: { anuncioId: id },
            });
        }
        else if (anuncio.categoria === anuncio_entity_1.CategoriaAnuncio.VEICULOS) {
            detalhes = await this.detalhesVeiculoRepository.findOne({
                where: { anuncioId: id },
            });
        }
        return {
            ...anuncio,
            detalhes,
            vendedor: {
                id: anuncio.vendedor.id,
                nome: anuncio.vendedor.nome,
                telefone: anuncio.vendedor.telefone,
                seloVerificado: anuncio.vendedor.seloVerificado,
            },
        };
    }
    async aplicarMarcaDagua(buffer, nomeArquivo) {
        const timestamp = Date.now();
        const nomeUnico = `${timestamp}-${nomeArquivo}`;
        const caminhoOriginal = (0, node_path_1.join)(process.cwd(), 'uploads', 'anuncios', 'originais', nomeUnico);
        const caminhoMarca = (0, node_path_1.join)(process.cwd(), 'uploads', 'anuncios', 'marca-dagua', nomeUnico);
        await (0, promises_1.mkdir)((0, node_path_1.join)(process.cwd(), 'uploads', 'anuncios', 'originais'), { recursive: true });
        await (0, promises_1.mkdir)((0, node_path_1.join)(process.cwd(), 'uploads', 'anuncios', 'marca-dagua'), { recursive: true });
        await (0, promises_1.writeFile)(caminhoOriginal, buffer);
        const marcaDagua = Buffer.from(`<svg width="300" height="50">
        <style>
          .texto { font-family: Arial, sans-serif; font-size: 28px; font-weight: bold; fill: white; opacity: 0.7; }
        </style>
        <text x="10" y="35" class="texto">TudoAqui</text>
      </svg>`);
        const imagemComMarca = await (0, sharp_1.default)(buffer)
            .resize(1200, 800, { fit: 'inside', withoutEnlargement: true })
            .composite([
            {
                input: marcaDagua,
                gravity: 'southeast',
            },
        ])
            .jpeg({ quality: 85 })
            .toBuffer();
        await (0, promises_1.writeFile)(caminhoMarca, imagemComMarca);
        return {
            urlOriginal: `/uploads/anuncios/originais/${nomeUnico}`,
            urlComMarca: `/uploads/anuncios/marca-dagua/${nomeUnico}`,
        };
    }
};
exports.MarketplaceService = MarketplaceService;
exports.MarketplaceService = MarketplaceService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(anuncio_entity_1.Anuncio)),
    __param(1, (0, typeorm_1.InjectRepository)(detalhes_imovel_entity_1.DetalhesImovel)),
    __param(2, (0, typeorm_1.InjectRepository)(detalhes_veiculo_entity_1.DetalhesVeiculo)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], MarketplaceService);
//# sourceMappingURL=marketplace.service.js.map