"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PagamentosController = void 0;
const common_1 = require("@nestjs/common");
const pagamentos_service_1 = require("./pagamentos.service");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
let PagamentosController = class PagamentosController {
    constructor(pagamentosService) {
        this.pagamentosService = pagamentosService;
    }
    async iniciarPagamento(req, dados) {
        return this.pagamentosService.iniciarPagamento(dados);
    }
    async verificarStatus(transacaoId) {
        return this.pagamentosService.verificarStatusPagamento(transacaoId);
    }
    async webhook(payload) {
        return this.pagamentosService.processarWebhookPagamento(payload);
    }
    async calcularTaxa(valor) {
        const taxa = this.pagamentosService.calcularTaxaPlataforma(valor);
        return {
            valorOriginal: valor,
            taxa,
            valorComTaxa: valor + taxa,
        };
    }
};
exports.PagamentosController = PagamentosController;
__decorate([
    (0, common_1.Post)('iniciar'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], PagamentosController.prototype, "iniciarPagamento", null);
__decorate([
    (0, common_1.Get)('status/:transacaoId'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Param)('transacaoId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PagamentosController.prototype, "verificarStatus", null);
__decorate([
    (0, common_1.Post)('webhook'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PagamentosController.prototype, "webhook", null);
__decorate([
    (0, common_1.Get)('taxa/:valor'),
    __param(0, (0, common_1.Param)('valor')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], PagamentosController.prototype, "calcularTaxa", null);
exports.PagamentosController = PagamentosController = __decorate([
    (0, common_1.Controller)('pagamentos'),
    __metadata("design:paramtypes", [pagamentos_service_1.PagamentosService])
], PagamentosController);
//# sourceMappingURL=pagamentos.controller.js.map