import { ConfigService } from '@nestjs/config';
interface PagamentoDto {
    valor: number;
    telefone: string;
    descricao: string;
    referencia: string;
}
interface StatusPagamentoResponse {
    transacaoId: string;
    status: 'pendente' | 'aprovado' | 'rejeitado' | 'cancelado';
    valor: number;
    dataHora: Date;
}
export declare class PagamentosService {
    private readonly configService;
    private readonly multicaixaMerchantId;
    private readonly gpoApiKey;
    constructor(configService: ConfigService);
    iniciarPagamento(dados: PagamentoDto): Promise<{
        success: boolean;
        transacaoId: string;
        mensagem: string;
        status: string;
        valor: number;
        telefone: string;
    }>;
    verificarStatusPagamento(transacaoId: string): Promise<StatusPagamentoResponse>;
    processarWebhookPagamento(payload: any): Promise<{
        success: boolean;
        message: string;
    }>;
    calcularTaxaPlataforma(valorTotal: number): number;
}
export {};
