"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PagamentosService = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
let PagamentosService = class PagamentosService {
    constructor(configService) {
        this.configService = configService;
        this.multicaixaMerchantId = this.configService.get('MULTICAIXA_MERCHANT_ID') || 'mock-merchant-id';
        this.gpoApiKey = this.configService.get('GPO_API_KEY') || 'mock-gpo-key';
    }
    async iniciarPagamento(dados) {
        try {
            console.log('💳 Iniciando pagamento Multicaixa Express:', dados);
            const transacaoId = `MCX-${Date.now()}`;
            return {
                success: true,
                transacaoId,
                mensagem: 'Pagamento iniciado. Confirme no seu Multicaixa Express.',
                status: 'pendente',
                valor: dados.valor,
                telefone: dados.telefone,
            };
        }
        catch (error) {
            console.error('Erro ao iniciar pagamento:', error);
            throw new common_1.HttpException('Erro ao processar pagamento', common_1.HttpStatus.SERVICE_UNAVAILABLE);
        }
    }
    async verificarStatusPagamento(transacaoId) {
        console.log('🔍 Verificando status de pagamento:', transacaoId);
        return {
            transacaoId,
            status: 'pendente',
            valor: 5000,
            dataHora: new Date(),
        };
    }
    async processarWebhookPagamento(payload) {
        console.log('📲 Webhook recebido:', payload);
        const { transacao_id, status, valor, referencia } = payload;
        if (status === 'aprovado') {
            console.log(`✅ Pagamento aprovado: ${transacao_id} - Valor: ${valor} Kz`);
            return {
                success: true,
                message: 'Pagamento processado com sucesso',
            };
        }
        if (status === 'rejeitado') {
            console.log(`❌ Pagamento rejeitado: ${transacao_id}`);
            return {
                success: false,
                message: 'Pagamento rejeitado',
            };
        }
        return {
            success: true,
            message: 'Webhook processado',
        };
    }
    calcularTaxaPlataforma(valorTotal) {
        const percentualTaxa = 0.025;
        return Math.ceil(valorTotal * percentualTaxa);
    }
};
exports.PagamentosService = PagamentosService;
exports.PagamentosService = PagamentosService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], PagamentosService);
//# sourceMappingURL=pagamentos.service.js.map