"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reserva = exports.StatusReserva = exports.TipoServico = void 0;
const typeorm_1 = require("typeorm");
const user_entity_1 = require("../../auth/entities/user.entity");
var TipoServico;
(function (TipoServico) {
    TipoServico["RESTAURANTE"] = "restaurante";
    TipoServico["GUIA_TURISTICO"] = "guia_turistico";
    TipoServico["HOTEL"] = "hotel";
    TipoServico["TRANSPORTE"] = "transporte";
    TipoServico["SEGUROS"] = "seguros";
    TipoServico["OUTROS"] = "outros";
})(TipoServico || (exports.TipoServico = TipoServico = {}));
var StatusReserva;
(function (StatusReserva) {
    StatusReserva["PENDENTE"] = "pendente";
    StatusReserva["CONFIRMADA"] = "confirmada";
    StatusReserva["CANCELADA"] = "cancelada";
    StatusReserva["CONCLUIDA"] = "concluida";
})(StatusReserva || (exports.StatusReserva = StatusReserva = {}));
let Reserva = class Reserva {
};
exports.Reserva = Reserva;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)("uuid"),
    __metadata("design:type", String)
], Reserva.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.User),
    (0, typeorm_1.JoinColumn)({ name: "cliente_id" }),
    __metadata("design:type", user_entity_1.User)
], Reserva.prototype, "cliente", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Reserva.prototype, "clienteId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: TipoServico }),
    __metadata("design:type", String)
], Reserva.prototype, "tipoServico", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Reserva.prototype, "servicoNome", void 0);
__decorate([
    (0, typeorm_1.Column)("timestamp"),
    __metadata("design:type", Date)
], Reserva.prototype, "dataReserva", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Reserva.prototype, "horario", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "int", default: 1 }),
    __metadata("design:type", Number)
], Reserva.prototype, "numeroPessoas", void 0);
__decorate([
    (0, typeorm_1.Column)("text", { nullable: true }),
    __metadata("design:type", String)
], Reserva.prototype, "observacoes", void 0);
__decorate([
    (0, typeorm_1.Column)("decimal", { precision: 10, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], Reserva.prototype, "valorTotal", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "enum",
        enum: StatusReserva,
        default: StatusReserva.PENDENTE,
    }),
    __metadata("design:type", String)
], Reserva.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)("simple-json", { nullable: true }),
    __metadata("design:type", Object)
], Reserva.prototype, "detalhesAdicionais", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Reserva.prototype, "createdAt", void 0);
exports.Reserva = Reserva = __decorate([
    (0, typeorm_1.Entity)("reservas")
], Reserva);
//# sourceMappingURL=reserva.entity.js.map