"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServicosController = void 0;
const common_1 = require("@nestjs/common");
const servicos_service_1 = require("./servicos.service");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const servicos_dto_1 = require("./dto/servicos.dto");
let ServicosController = class ServicosController {
    constructor(servicosService) {
        this.servicosService = servicosService;
    }
    async criarReserva(req, dto) {
        return this.servicosService.criarReserva(req.user.userId, dto);
    }
    async listarReservas(req) {
        return this.servicosService.listarReservasUtilizador(req.user.userId);
    }
    async solicitarCotacao(req, dto) {
        return this.servicosService.solicitarCotacaoSeguro(req.user.userId, dto);
    }
    async obterCotacao(req, id) {
        return this.servicosService.obterCotacao(id, req.user.userId);
    }
};
exports.ServicosController = ServicosController;
__decorate([
    (0, common_1.Post)("reservas"),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, servicos_dto_1.CriarReservaDto]),
    __metadata("design:returntype", Promise)
], ServicosController.prototype, "criarReserva", null);
__decorate([
    (0, common_1.Get)("reservas"),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ServicosController.prototype, "listarReservas", null);
__decorate([
    (0, common_1.Post)("seguros/cotacao"),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, servicos_dto_1.CotacaoSeguroDto]),
    __metadata("design:returntype", Promise)
], ServicosController.prototype, "solicitarCotacao", null);
__decorate([
    (0, common_1.Get)("seguros/cotacao/:id"),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], ServicosController.prototype, "obterCotacao", null);
exports.ServicosController = ServicosController = __decorate([
    (0, common_1.Controller)("servicos"),
    __metadata("design:paramtypes", [servicos_service_1.ServicosService])
], ServicosController);
//# sourceMappingURL=servicos.controller.js.map