import { Repository } from 'typeorm';
import { Reserva, StatusReserva } from './entities/reserva.entity';
import { CotacaoSeguro, TipoSeguro } from './entities/cotacao-seguro.entity';
import { CriarReservaDto, CotacaoSeguroDto } from './dto/servicos.dto';
export declare class ServicosService {
    private readonly reservaRepository;
    private readonly cotacaoRepository;
    constructor(reservaRepository: Repository<Reserva>, cotacaoRepository: Repository<CotacaoSeguro>);
    criarReserva(userId: string, dto: CriarReservaDto): Promise<{
        message: string;
        reserva: {
            id: string;
            servicoNome: string;
            dataReserva: Date;
            status: StatusReserva;
        };
    }>;
    listarReservasUtilizador(userId: string): Promise<{
        total: number;
        reservas: Reserva[];
    }>;
    solicitarCotacaoSeguro(userId: string, dto: CotacaoSeguroDto): Promise<{
        message: string;
        cotacao: {
            id: string;
            tipo: TipoSeguro;
            valorMensal: number;
            valorAnual: number;
            seguradoraParceira: string;
        };
    }>;
    obterCotacao(cotacaoId: string, userId: string): Promise<CotacaoSeguro>;
    private calcularSeguroAutomovel;
}
