"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServicosService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const reserva_entity_1 = require("./entities/reserva.entity");
const cotacao_seguro_entity_1 = require("./entities/cotacao-seguro.entity");
let ServicosService = class ServicosService {
    constructor(reservaRepository, cotacaoRepository) {
        this.reservaRepository = reservaRepository;
        this.cotacaoRepository = cotacaoRepository;
    }
    async criarReserva(userId, dto) {
        const reserva = this.reservaRepository.create({
            clienteId: userId,
            tipoServico: dto.tipoServico,
            servicoNome: dto.servicoNome,
            dataReserva: dto.dataReserva,
            horario: dto.horario,
            numeroPessoas: dto.numeroPessoas,
            observacoes: dto.observacoes,
            detalhesAdicionais: dto.detalhesAdicionais,
            status: reserva_entity_1.StatusReserva.PENDENTE,
        });
        await this.reservaRepository.save(reserva);
        console.log('📅 Nova reserva criada:', reserva.id);
        return {
            message: 'Reserva criada com sucesso',
            reserva: {
                id: reserva.id,
                servicoNome: reserva.servicoNome,
                dataReserva: reserva.dataReserva,
                status: reserva.status,
            },
        };
    }
    async listarReservasUtilizador(userId) {
        const reservas = await this.reservaRepository.find({
            where: { clienteId: userId },
            order: { dataReserva: 'ASC' },
        });
        return {
            total: reservas.length,
            reservas,
        };
    }
    async solicitarCotacaoSeguro(userId, dto) {
        const cotacao = this.cotacaoRepository.create({
            userId,
            tipo: dto.tipo,
            nomeCompleto: dto.nomeCompleto,
            telefone: dto.telefone,
            email: dto.email,
            veiculoMarca: dto.veiculoMarca,
            veiculoModelo: dto.veiculoModelo,
            veiculoAno: dto.veiculoAno,
            veiculoChaveta: dto.veiculoChaveta,
            status: cotacao_seguro_entity_1.StatusCotacao.PENDENTE,
        });
        if (dto.tipo === cotacao_seguro_entity_1.TipoSeguro.AUTOMOVEL) {
            cotacao.valorMensal = this.calcularSeguroAutomovel(dto.veiculoAno || 2020);
            cotacao.valorAnual = cotacao.valorMensal * 12;
            cotacao.seguradoraParceira = 'ENSA Seguros';
        }
        await this.cotacaoRepository.save(cotacao);
        console.log('🛡️ Nova cotação de seguro solicitada:', cotacao.id);
        return {
            message: 'Cotação gerada com sucesso',
            cotacao: {
                id: cotacao.id,
                tipo: cotacao.tipo,
                valorMensal: cotacao.valorMensal,
                valorAnual: cotacao.valorAnual,
                seguradoraParceira: cotacao.seguradoraParceira,
            },
        };
    }
    async obterCotacao(cotacaoId, userId) {
        const cotacao = await this.cotacaoRepository.findOne({
            where: { id: cotacaoId, userId },
        });
        if (!cotacao) {
            throw new common_1.NotFoundException('Cotação não encontrada');
        }
        return cotacao;
    }
    calcularSeguroAutomovel(ano) {
        const anoAtual = new Date().getFullYear();
        const idade = anoAtual - ano;
        let valorBase = 15000;
        if (idade > 10) {
            valorBase += 5000;
        }
        if (idade < 3) {
            valorBase += 8000;
        }
        return valorBase;
    }
};
exports.ServicosService = ServicosService;
exports.ServicosService = ServicosService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(reserva_entity_1.Reserva)),
    __param(1, (0, typeorm_1.InjectRepository)(cotacao_seguro_entity_1.CotacaoSeguro)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], ServicosService);
//# sourceMappingURL=servicos.service.js.map