import { createAggregatedClient } from "@smithy/smithy-client";
import { AssociateFacesCommand, } from "./commands/AssociateFacesCommand";
import { CompareFacesCommand, } from "./commands/CompareFacesCommand";
import { CopyProjectVersionCommand, } from "./commands/CopyProjectVersionCommand";
import { CreateCollectionCommand, } from "./commands/CreateCollectionCommand";
import { CreateDatasetCommand, } from "./commands/CreateDatasetCommand";
import { CreateFaceLivenessSessionCommand, } from "./commands/CreateFaceLivenessSessionCommand";
import { CreateProjectCommand, } from "./commands/CreateProjectCommand";
import { CreateProjectVersionCommand, } from "./commands/CreateProjectVersionCommand";
import { CreateStreamProcessorCommand, } from "./commands/CreateStreamProcessorCommand";
import { CreateUserCommand } from "./commands/CreateUserCommand";
import { DeleteCollectionCommand, } from "./commands/DeleteCollectionCommand";
import { DeleteDatasetCommand, } from "./commands/DeleteDatasetCommand";
import { DeleteFacesCommand } from "./commands/DeleteFacesCommand";
import { DeleteProjectCommand, } from "./commands/DeleteProjectCommand";
import { DeleteProjectPolicyCommand, } from "./commands/DeleteProjectPolicyCommand";
import { DeleteProjectVersionCommand, } from "./commands/DeleteProjectVersionCommand";
import { DeleteStreamProcessorCommand, } from "./commands/DeleteStreamProcessorCommand";
import { DeleteUserCommand } from "./commands/DeleteUserCommand";
import { DescribeCollectionCommand, } from "./commands/DescribeCollectionCommand";
import { DescribeDatasetCommand, } from "./commands/DescribeDatasetCommand";
import { DescribeProjectsCommand, } from "./commands/DescribeProjectsCommand";
import { DescribeProjectVersionsCommand, } from "./commands/DescribeProjectVersionsCommand";
import { DescribeStreamProcessorCommand, } from "./commands/DescribeStreamProcessorCommand";
import { DetectCustomLabelsCommand, } from "./commands/DetectCustomLabelsCommand";
import { DetectFacesCommand } from "./commands/DetectFacesCommand";
import { DetectLabelsCommand, } from "./commands/DetectLabelsCommand";
import { DetectModerationLabelsCommand, } from "./commands/DetectModerationLabelsCommand";
import { DetectProtectiveEquipmentCommand, } from "./commands/DetectProtectiveEquipmentCommand";
import { DetectTextCommand } from "./commands/DetectTextCommand";
import { DisassociateFacesCommand, } from "./commands/DisassociateFacesCommand";
import { DistributeDatasetEntriesCommand, } from "./commands/DistributeDatasetEntriesCommand";
import { GetCelebrityInfoCommand, } from "./commands/GetCelebrityInfoCommand";
import { GetCelebrityRecognitionCommand, } from "./commands/GetCelebrityRecognitionCommand";
import { GetContentModerationCommand, } from "./commands/GetContentModerationCommand";
import { GetFaceDetectionCommand, } from "./commands/GetFaceDetectionCommand";
import { GetFaceLivenessSessionResultsCommand, } from "./commands/GetFaceLivenessSessionResultsCommand";
import { GetFaceSearchCommand, } from "./commands/GetFaceSearchCommand";
import { GetLabelDetectionCommand, } from "./commands/GetLabelDetectionCommand";
import { GetMediaAnalysisJobCommand, } from "./commands/GetMediaAnalysisJobCommand";
import { GetPersonTrackingCommand, } from "./commands/GetPersonTrackingCommand";
import { GetSegmentDetectionCommand, } from "./commands/GetSegmentDetectionCommand";
import { GetTextDetectionCommand, } from "./commands/GetTextDetectionCommand";
import { IndexFacesCommand } from "./commands/IndexFacesCommand";
import { ListCollectionsCommand, } from "./commands/ListCollectionsCommand";
import { ListDatasetEntriesCommand, } from "./commands/ListDatasetEntriesCommand";
import { ListDatasetLabelsCommand, } from "./commands/ListDatasetLabelsCommand";
import { ListFacesCommand } from "./commands/ListFacesCommand";
import { ListMediaAnalysisJobsCommand, } from "./commands/ListMediaAnalysisJobsCommand";
import { ListProjectPoliciesCommand, } from "./commands/ListProjectPoliciesCommand";
import { ListStreamProcessorsCommand, } from "./commands/ListStreamProcessorsCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { ListUsersCommand } from "./commands/ListUsersCommand";
import { PutProjectPolicyCommand, } from "./commands/PutProjectPolicyCommand";
import { RecognizeCelebritiesCommand, } from "./commands/RecognizeCelebritiesCommand";
import { SearchFacesByImageCommand, } from "./commands/SearchFacesByImageCommand";
import { SearchFacesCommand } from "./commands/SearchFacesCommand";
import { SearchUsersByImageCommand, } from "./commands/SearchUsersByImageCommand";
import { SearchUsersCommand } from "./commands/SearchUsersCommand";
import { StartCelebrityRecognitionCommand, } from "./commands/StartCelebrityRecognitionCommand";
import { StartContentModerationCommand, } from "./commands/StartContentModerationCommand";
import { StartFaceDetectionCommand, } from "./commands/StartFaceDetectionCommand";
import { StartFaceSearchCommand, } from "./commands/StartFaceSearchCommand";
import { StartLabelDetectionCommand, } from "./commands/StartLabelDetectionCommand";
import { StartMediaAnalysisJobCommand, } from "./commands/StartMediaAnalysisJobCommand";
import { StartPersonTrackingCommand, } from "./commands/StartPersonTrackingCommand";
import { StartProjectVersionCommand, } from "./commands/StartProjectVersionCommand";
import { StartSegmentDetectionCommand, } from "./commands/StartSegmentDetectionCommand";
import { StartStreamProcessorCommand, } from "./commands/StartStreamProcessorCommand";
import { StartTextDetectionCommand, } from "./commands/StartTextDetectionCommand";
import { StopProjectVersionCommand, } from "./commands/StopProjectVersionCommand";
import { StopStreamProcessorCommand, } from "./commands/StopStreamProcessorCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdateDatasetEntriesCommand, } from "./commands/UpdateDatasetEntriesCommand";
import { UpdateStreamProcessorCommand, } from "./commands/UpdateStreamProcessorCommand";
import { RekognitionClient } from "./RekognitionClient";
const commands = {
    AssociateFacesCommand,
    CompareFacesCommand,
    CopyProjectVersionCommand,
    CreateCollectionCommand,
    CreateDatasetCommand,
    CreateFaceLivenessSessionCommand,
    CreateProjectCommand,
    CreateProjectVersionCommand,
    CreateStreamProcessorCommand,
    CreateUserCommand,
    DeleteCollectionCommand,
    DeleteDatasetCommand,
    DeleteFacesCommand,
    DeleteProjectCommand,
    DeleteProjectPolicyCommand,
    DeleteProjectVersionCommand,
    DeleteStreamProcessorCommand,
    DeleteUserCommand,
    DescribeCollectionCommand,
    DescribeDatasetCommand,
    DescribeProjectsCommand,
    DescribeProjectVersionsCommand,
    DescribeStreamProcessorCommand,
    DetectCustomLabelsCommand,
    DetectFacesCommand,
    DetectLabelsCommand,
    DetectModerationLabelsCommand,
    DetectProtectiveEquipmentCommand,
    DetectTextCommand,
    DisassociateFacesCommand,
    DistributeDatasetEntriesCommand,
    GetCelebrityInfoCommand,
    GetCelebrityRecognitionCommand,
    GetContentModerationCommand,
    GetFaceDetectionCommand,
    GetFaceLivenessSessionResultsCommand,
    GetFaceSearchCommand,
    GetLabelDetectionCommand,
    GetMediaAnalysisJobCommand,
    GetPersonTrackingCommand,
    GetSegmentDetectionCommand,
    GetTextDetectionCommand,
    IndexFacesCommand,
    ListCollectionsCommand,
    ListDatasetEntriesCommand,
    ListDatasetLabelsCommand,
    ListFacesCommand,
    ListMediaAnalysisJobsCommand,
    ListProjectPoliciesCommand,
    ListStreamProcessorsCommand,
    ListTagsForResourceCommand,
    ListUsersCommand,
    PutProjectPolicyCommand,
    RecognizeCelebritiesCommand,
    SearchFacesCommand,
    SearchFacesByImageCommand,
    SearchUsersCommand,
    SearchUsersByImageCommand,
    StartCelebrityRecognitionCommand,
    StartContentModerationCommand,
    StartFaceDetectionCommand,
    StartFaceSearchCommand,
    StartLabelDetectionCommand,
    StartMediaAnalysisJobCommand,
    StartPersonTrackingCommand,
    StartProjectVersionCommand,
    StartSegmentDetectionCommand,
    StartStreamProcessorCommand,
    StartTextDetectionCommand,
    StopProjectVersionCommand,
    StopStreamProcessorCommand,
    TagResourceCommand,
    UntagResourceCommand,
    UpdateDatasetEntriesCommand,
    UpdateStreamProcessorCommand,
};
export class Rekognition extends RekognitionClient {
}
createAggregatedClient(commands, Rekognition);
