import { Command as $Command } from "@smithy/smithy-client";
import type { MetadataBearer as __MetadataBearer } from "@smithy/types";
import type { CreateDatasetRequest, CreateDatasetResponse } from "../models/models_0";
import type { RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../RekognitionClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CreateDatasetCommand}.
 */
export interface CreateDatasetCommandInput extends CreateDatasetRequest {
}
/**
 * @public
 *
 * The output of {@link CreateDatasetCommand}.
 */
export interface CreateDatasetCommandOutput extends CreateDatasetResponse, __MetadataBearer {
}
declare const CreateDatasetCommand_base: {
    new (input: CreateDatasetCommandInput): import("@smithy/smithy-client").CommandImpl<CreateDatasetCommandInput, CreateDatasetCommandOutput, RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CreateDatasetCommandInput): import("@smithy/smithy-client").CommandImpl<CreateDatasetCommandInput, CreateDatasetCommandOutput, RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <note>
 *             <p>This operation applies only to Amazon Rekognition Custom Labels.</p>
 *          </note>
 *          <p>Creates a new Amazon Rekognition Custom Labels dataset. You can create a dataset by using
 *    an Amazon Sagemaker format manifest file or by copying an existing Amazon Rekognition Custom Labels dataset.</p>
 *          <p>To create a training dataset for a project, specify <code>TRAIN</code> for the value of
 *       <code>DatasetType</code>. To create the test dataset for a project,
 *       specify <code>TEST</code> for the value of <code>DatasetType</code>.
 *     </p>
 *          <p>The response from <code>CreateDataset</code> is the Amazon Resource Name (ARN) for the dataset.
 *    Creating a dataset takes a while to complete. Use <a>DescribeDataset</a> to check the
 *    current status. The dataset created successfully if the value of <code>Status</code> is
 *    <code>CREATE_COMPLETE</code>. </p>
 *          <p>To check if any non-terminal errors occurred, call <a>ListDatasetEntries</a>
 * and check for the presence of <code>errors</code> lists in the JSON Lines.</p>
 *          <p>Dataset creation fails if a terminal error occurs (<code>Status</code> = <code>CREATE_FAILED</code>).
 *       Currently, you can't access the terminal error information.
 *
 *    </p>
 *          <p>For more information, see Creating dataset in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.</p>
 *          <p>This operation requires permissions to perform the <code>rekognition:CreateDataset</code> action.
 *    If you want to copy an existing dataset, you also require permission to perform the <code>rekognition:ListDatasetEntries</code> action.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { RekognitionClient, CreateDatasetCommand } from "@aws-sdk/client-rekognition"; // ES Modules import
 * // const { RekognitionClient, CreateDatasetCommand } = require("@aws-sdk/client-rekognition"); // CommonJS import
 * // import type { RekognitionClientConfig } from "@aws-sdk/client-rekognition";
 * const config = {}; // type is RekognitionClientConfig
 * const client = new RekognitionClient(config);
 * const input = { // CreateDatasetRequest
 *   DatasetSource: { // DatasetSource
 *     GroundTruthManifest: { // GroundTruthManifest
 *       S3Object: { // S3Object
 *         Bucket: "STRING_VALUE",
 *         Name: "STRING_VALUE",
 *         Version: "STRING_VALUE",
 *       },
 *     },
 *     DatasetArn: "STRING_VALUE",
 *   },
 *   DatasetType: "TRAIN" || "TEST", // required
 *   ProjectArn: "STRING_VALUE", // required
 *   Tags: { // TagMap
 *     "<keys>": "STRING_VALUE",
 *   },
 * };
 * const command = new CreateDatasetCommand(input);
 * const response = await client.send(command);
 * // { // CreateDatasetResponse
 * //   DatasetArn: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param CreateDatasetCommandInput - {@link CreateDatasetCommandInput}
 * @returns {@link CreateDatasetCommandOutput}
 * @see {@link CreateDatasetCommandInput} for command's `input` shape.
 * @see {@link CreateDatasetCommandOutput} for command's `response` shape.
 * @see {@link RekognitionClientResolvedConfig | config} for RekognitionClient's `config` shape.
 *
 * @throws {@link AccessDeniedException} (client fault)
 *  <p>You are not authorized to perform the action.</p>
 *
 * @throws {@link InternalServerError} (server fault)
 *  <p>Amazon Rekognition experienced a service issue. Try your call again.</p>
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>Input parameter violated a constraint. Validate your parameter before calling the API
 *       operation again.</p>
 *
 * @throws {@link InvalidS3ObjectException} (client fault)
 *  <p>Amazon Rekognition is unable to access the S3 object specified in the request.</p>
 *
 * @throws {@link LimitExceededException} (client fault)
 *  <p>An Amazon Rekognition service limit was exceeded. For example, if you start too many jobs
 *             concurrently, subsequent calls to start operations (ex:
 *             <code>StartLabelDetection</code>) will raise a <code>LimitExceededException</code>
 *             exception (HTTP status code: 400) until the number of concurrently running jobs is below
 *             the Amazon Rekognition service limit. </p>
 *
 * @throws {@link ProvisionedThroughputExceededException} (client fault)
 *  <p>The number of requests exceeded your throughput limit. If you want to increase this
 *       limit, contact Amazon Rekognition.</p>
 *
 * @throws {@link ResourceAlreadyExistsException} (client fault)
 *  <p>A resource with the specified ID already exists.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The resource specified in the request cannot be found.</p>
 *
 * @throws {@link ThrottlingException} (server fault)
 *  <p>Amazon Rekognition is temporarily unable to process the request. Try your call again.</p>
 *
 * @throws {@link RekognitionServiceException}
 * <p>Base exception class for all service exceptions from Rekognition service.</p>
 *
 *
 * @example To create an Amazon Rekognition Custom Labels dataset
 * ```javascript
 * // Creates an Amazon Rekognition Custom Labels dataset with a manifest file stored in an Amazon S3 bucket.
 * const input = {
 *   DatasetSource: {
 *     GroundTruthManifest: {
 *       S3Object: {
 *         Bucket: "my-bucket",
 *         Name: "datasets/flowers_training/manifests/output/output.manifest"
 *       }
 *     }
 *   },
 *   DatasetType: "TRAIN",
 *   ProjectArn: "arn:aws:rekognition:us-east-1:111122223333:project/my-project/1690474772815"
 * };
 * const command = new CreateDatasetCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   DatasetArn: "arn:aws:rekognition:us-east-1:111122223333:project/my-project/dataset/train/1690476084535"
 * }
 * *\/
 * ```
 *
 * @public
 */
export declare class CreateDatasetCommand extends CreateDatasetCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CreateDatasetRequest;
            output: CreateDatasetResponse;
        };
        sdk: {
            input: CreateDatasetCommandInput;
            output: CreateDatasetCommandOutput;
        };
    };
}
