import { Command as $Command } from "@smithy/smithy-client";
import type { MetadataBearer as __MetadataBearer } from "@smithy/types";
import type { CreateProjectRequest, CreateProjectResponse } from "../models/models_0";
import type { RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../RekognitionClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CreateProjectCommand}.
 */
export interface CreateProjectCommandInput extends CreateProjectRequest {
}
/**
 * @public
 *
 * The output of {@link CreateProjectCommand}.
 */
export interface CreateProjectCommandOutput extends CreateProjectResponse, __MetadataBearer {
}
declare const CreateProjectCommand_base: {
    new (input: CreateProjectCommandInput): import("@smithy/smithy-client").CommandImpl<CreateProjectCommandInput, CreateProjectCommandOutput, RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CreateProjectCommandInput): import("@smithy/smithy-client").CommandImpl<CreateProjectCommandInput, CreateProjectCommandOutput, RekognitionClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates a new Amazon Rekognition project. A project is a group of resources (datasets, model
 *          versions) that you use to create and manage a Amazon Rekognition Custom Labels Model or custom adapter. You can
 *          specify a feature to create the project with, if no feature is specified then Custom Labels
 *          is used by default. For adapters, you can also choose whether or not to have the project
 *          auto update by using the AutoUpdate argument. This operation requires permissions to
 *          perform the <code>rekognition:CreateProject</code> action.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { RekognitionClient, CreateProjectCommand } from "@aws-sdk/client-rekognition"; // ES Modules import
 * // const { RekognitionClient, CreateProjectCommand } = require("@aws-sdk/client-rekognition"); // CommonJS import
 * // import type { RekognitionClientConfig } from "@aws-sdk/client-rekognition";
 * const config = {}; // type is RekognitionClientConfig
 * const client = new RekognitionClient(config);
 * const input = { // CreateProjectRequest
 *   ProjectName: "STRING_VALUE", // required
 *   Feature: "CONTENT_MODERATION" || "CUSTOM_LABELS",
 *   AutoUpdate: "ENABLED" || "DISABLED",
 *   Tags: { // TagMap
 *     "<keys>": "STRING_VALUE",
 *   },
 * };
 * const command = new CreateProjectCommand(input);
 * const response = await client.send(command);
 * // { // CreateProjectResponse
 * //   ProjectArn: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param CreateProjectCommandInput - {@link CreateProjectCommandInput}
 * @returns {@link CreateProjectCommandOutput}
 * @see {@link CreateProjectCommandInput} for command's `input` shape.
 * @see {@link CreateProjectCommandOutput} for command's `response` shape.
 * @see {@link RekognitionClientResolvedConfig | config} for RekognitionClient's `config` shape.
 *
 * @throws {@link AccessDeniedException} (client fault)
 *  <p>You are not authorized to perform the action.</p>
 *
 * @throws {@link InternalServerError} (server fault)
 *  <p>Amazon Rekognition experienced a service issue. Try your call again.</p>
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>Input parameter violated a constraint. Validate your parameter before calling the API
 *       operation again.</p>
 *
 * @throws {@link LimitExceededException} (client fault)
 *  <p>An Amazon Rekognition service limit was exceeded. For example, if you start too many jobs
 *             concurrently, subsequent calls to start operations (ex:
 *             <code>StartLabelDetection</code>) will raise a <code>LimitExceededException</code>
 *             exception (HTTP status code: 400) until the number of concurrently running jobs is below
 *             the Amazon Rekognition service limit. </p>
 *
 * @throws {@link ProvisionedThroughputExceededException} (client fault)
 *  <p>The number of requests exceeded your throughput limit. If you want to increase this
 *       limit, contact Amazon Rekognition.</p>
 *
 * @throws {@link ResourceInUseException} (client fault)
 *  <p>The specified resource is already being used.</p>
 *
 * @throws {@link ThrottlingException} (server fault)
 *  <p>Amazon Rekognition is temporarily unable to process the request. Try your call again.</p>
 *
 * @throws {@link RekognitionServiceException}
 * <p>Base exception class for all service exceptions from Rekognition service.</p>
 *
 *
 * @example To create an Amazon Rekognition Custom Labels project
 * ```javascript
 * // Creates an Amazon Rekognition Custom Labels project.
 * const input = {
 *   ProjectName: "my-project"
 * };
 * const command = new CreateProjectCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   ProjectArn: "arn:aws:rekognition:us-east-1:111122223333:project/my-project/1690405809285"
 * }
 * *\/
 * ```
 *
 * @public
 */
export declare class CreateProjectCommand extends CreateProjectCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CreateProjectRequest;
            output: CreateProjectResponse;
        };
        sdk: {
            input: CreateProjectCommandInput;
            output: CreateProjectCommandOutput;
        };
    };
}
